/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7923;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EntityEmiStack
extends EmiStack {
    @Nullable
    private final class_1297 entity;
    private final float scale;

    protected EntityEmiStack(@Nullable class_1297 entity, float scale) {
        this.entity = entity;
        this.scale = scale;
    }

    public static EntityEmiStack of(@Nullable class_1297 entity) {
        return EntityEmiStack.ofScaled(entity, 8.0f);
    }

    public static EntityEmiStack ofScaled(@Nullable class_1297 entity, float scale) {
        return new EntityEmiStack(entity, scale);
    }

    public EmiStack copy() {
        EntityEmiStack stack = EntityEmiStack.ofScaled(this.entity, this.scale);
        stack.setRemainder(this.getRemainder().copy());
        stack.comparison = this.comparison;
        return stack;
    }

    public boolean isEmpty() {
        return this.entity == null;
    }

    public void render(class_332 draw, int x, int y, float delta, int flags) {
        if (this.entity != null) {
            class_312 mouse = class_310.method_1551().field_1729;
            class_1297 class_12972 = this.entity;
            if (class_12972 instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                EntityEmiStack.drawLivingEntity(draw, x, y, this.scale, (float)mouse.method_1603(), (float)mouse.method_1604(), living);
            } else {
                EntityEmiStack.drawEntity(draw, x, y, this.scale, (float)mouse.method_1603(), (float)mouse.method_1604(), this.entity);
            }
        }
    }

    public class_2487 getNbt() {
        return Optional.ofNullable(this.entity).map(e -> e.method_5647(new class_2487())).orElse(new class_2487());
    }

    public Object getKey() {
        return this.entity;
    }

    public class_2960 getId() {
        if (this.entity == null) {
            throw new RuntimeException("Entity is null");
        }
        return class_7923.field_41177.method_10221((Object)this.entity.method_5864());
    }

    public List<class_2561> getTooltipText() {
        return List.of(this.getName());
    }

    public List<class_5684> getTooltip() {
        ArrayList<class_5684> list = new ArrayList<class_5684>();
        if (this.entity != null) {
            String mod;
            list.addAll(this.getTooltipText().stream().map(EmiPort::ordered).map(class_5684::method_32662).toList());
            class_1297 class_12972 = this.entity;
            if (class_12972 instanceof class_1646) {
                class_1646 villager = (class_1646)class_12972;
                mod = EmiUtil.getModName((String)class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924()).method_12836());
            } else {
                mod = EmiUtil.getModName((String)class_7923.field_41177.method_10221((Object)this.entity.method_5864()).method_12836());
            }
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal((String)mod, (class_124[])new class_124[]{class_124.field_1078, class_124.field_1056}))));
            if (!this.getRemainder().isEmpty()) {
                list.add((class_5684)new RemainderTooltipComponent((EmiIngredient)this));
            }
        }
        return list;
    }

    public class_2561 getName() {
        return this.entity != null ? this.entity.method_5477() : EmiPort.literal((String)"yet another missingno");
    }

    public static void drawLivingEntity(class_332 ctx, int x, int y, float size, float mouseX, float mouseY, class_1309 entity) {
        float mouseX0 = (float)(ctx.method_51421() + 51) - mouseX;
        float mouseY0 = (float)(ctx.method_51443() + 75 - 50) - mouseY;
        float f = (float)Math.atan(mouseX0 / 40.0f);
        float g = (float)Math.atan(mouseY0 / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float h = entity.field_6283;
        float i = entity.method_36454();
        float j = entity.method_36455();
        float k = entity.field_6259;
        float l = entity.field_6241;
        entity.field_6283 = 180.0f + f * 20.0f;
        entity.method_36456(180.0f + f * 40.0f);
        entity.method_36457(-g * 20.0f);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        EntityEmiStack.draw(ctx, x, y, size, quaternionf, quaternionf2, (class_1297)entity);
        entity.field_6283 = h;
        entity.method_36456(i);
        entity.method_36457(j);
        entity.field_6259 = k;
        entity.field_6241 = l;
    }

    public static void drawEntity(class_332 ctx, int x, int y, float size, float mouseX, float mouseY, class_1297 entity) {
        float mouseX0 = (float)(ctx.method_51421() + 51) - mouseX;
        float mouseY0 = (float)(ctx.method_51443() + 75 - 50) - mouseY;
        float f = (float)Math.atan(mouseX0 / 40.0f);
        float g = (float)Math.atan(mouseY0 / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float i = entity.method_36454();
        float j = entity.method_36455();
        entity.method_36456(180.0f + f * 40.0f);
        entity.method_36457(-g * 20.0f);
        EntityEmiStack.draw(ctx, x, y, size, quaternionf, quaternionf2, entity);
        entity.method_36456(i);
        entity.method_36457(j);
    }

    private static void draw(class_332 ctx, int x, int y, float size, Quaternionf quaternion, @Nullable Quaternionf quaternion2, class_1297 entity) {
        ctx.method_51448().method_22903();
        ctx.method_51448().method_22904((double)(x + 8), (double)(y + 16), 50.0);
        ctx.method_51448().method_34425(new Matrix4f().scaling(size, size, -size));
        ctx.method_51448().method_22907(quaternion);
        class_308.method_34742();
        class_898 dispatcher = class_310.method_1551().method_1561();
        if (quaternion2 != null) {
            quaternion2.conjugate();
            dispatcher.method_24196(quaternion2);
        }
        dispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> dispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ctx.method_51448(), (class_4597)ctx.method_51450(), 0xF000F0));
        ctx.method_51452();
        dispatcher.method_3948(true);
        ctx.method_51448().method_22909();
        class_308.method_24211();
    }
}

