/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.registry.LithostitchedRegistries;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.TrueModifierPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_3542;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class Modifier {
    public static final Codec<Modifier> CODEC = class_5699.method_39240(() -> {
        class_2378 modifierRegistry = (class_2378)class_7923.field_41167.method_10223(LithostitchedRegistries.MODIFIER_TYPE.method_29177());
        if (modifierRegistry == null) {
            throw new NullPointerException("Worldgen modifier registry does not exist yet!");
        }
        return modifierRegistry.method_39673();
    }).dispatch(Modifier::codec, Function.identity());
    private final ModifierPredicate predicate;
    private final ModifierPhase phase;

    protected Modifier(ModifierPredicate modifierPredicate, ModifierPhase phase) {
        this.predicate = modifierPredicate;
        this.phase = phase;
    }

    public static <P extends Modifier> Products.P1<RecordCodecBuilder.Mu<P>, ModifierPredicate> addModifierFields(RecordCodecBuilder.Instance<P> codec) {
        return codec.group((App)ModifierPredicate.CODEC.fieldOf("predicate").orElse((Object)TrueModifierPredicate.INSTANCE).forGetter(Modifier::predicate));
    }

    public ModifierPredicate predicate() {
        return this.predicate;
    }

    public ModifierPhase phase() {
        return this.phase;
    }

    public void applyModifier(class_5455 registryAccess) {
        this.applyModifier();
    }

    public abstract void applyModifier();

    public abstract Codec<? extends Modifier> codec();

    public static void applyModifiers(MinecraftServer server) {
        class_5455.class_6890 registries = server.method_30611();
        class_2378 modifiers = registries.method_30530(LithostitchedRegistries.WORLDGEN_MODIFIER);
        for (ModifierPhase phase : ModifierPhase.values()) {
            if (phase == ModifierPhase.NONE) continue;
            for (Modifier modifier2 : modifiers.method_10220().filter(modifier -> modifier.phase() == phase).collect(Collectors.toSet())) {
                if (!modifier2.predicate().test()) continue;
                modifier2.applyModifier((class_5455)registries);
            }
        }
    }

    public static enum ModifierPhase implements class_3542
    {
        NONE("none"),
        BEFORE_ALL("before_all"),
        ADD("add"),
        REMOVE("remove"),
        MODIFY("modify"),
        AFTER_ALL("after_all");

        private final String name;

        private ModifierPhase(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }
}

