/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.access.StructurePoolAccess;
import dev.worldgen.lithostitched.worldgen.poolelement.ExclusivePoolElement;
import dev.worldgen.lithostitched.worldgen.poolelement.GuaranteedPoolElement;
import dev.worldgen.lithostitched.worldgen.poolelement.LimitedPoolElement;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6032;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableObject;

public class AlternateJigsawGenerator {
    public static Optional<class_3195.class_7150> generate(class_3195.class_7149 context, class_6880<class_3785> structurePool, Optional<class_2960> id, int size, class_2338 pos, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        class_2338 blockPos;
        class_5455 dynamicRegistryManager = context.comp_561();
        class_2794 chunkGenerator = context.comp_562();
        class_3485 structureTemplateManager = context.comp_565();
        class_5539 heightLimitView = context.comp_569();
        class_2919 chunkRandom = context.comp_566();
        class_2378 registry = dynamicRegistryManager.method_30530(class_7924.field_41249);
        class_2470 blockRotation = class_2470.method_16548((class_5819)chunkRandom);
        class_3785 structurePool2 = (class_3785)structurePool.comp_349();
        class_3784 structurePoolElement = structurePool2.method_16631((class_5819)chunkRandom);
        if (structurePoolElement == class_3777.field_16663) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            class_2960 identifier = id.get();
            Optional<class_2338> optional = AlternateJigsawGenerator.findStartingJigsawPos(structurePoolElement, identifier, pos, blockRotation, structureTemplateManager, chunkRandom);
            if (optional.isEmpty()) {
                LithostitchedCommon.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)structurePool.method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = pos;
        }
        class_2338 vec3i = blockPos.method_10059((class_2382)pos);
        class_2338 blockPos2 = pos.method_10059((class_2382)vec3i);
        class_3790 poolStructurePiece = new class_3790(structureTemplateManager, structurePoolElement, blockPos2, structurePoolElement.method_19308(), blockRotation, structurePoolElement.method_16628(structureTemplateManager, blockPos2, blockRotation));
        class_3341 blockBox = poolStructurePiece.method_14935();
        int i = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int j = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        int k = projectStartToHeightmap.map(type -> pos.method_10264() + chunkGenerator.method_20402(i, j, type, heightLimitView, context.comp_564())).orElseGet(() -> ((class_2338)blockPos2).method_10264());
        int l = blockBox.method_35416() + poolStructurePiece.method_16646();
        poolStructurePiece.method_14922(0, k - l, 0);
        int m = k + vec3i.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(i, m, j), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (size > 0) {
                class_238 box = new class_238((double)(i - maxDistanceFromCenter), (double)(m - maxDistanceFromCenter), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)(m + maxDistanceFromCenter + 1), (double)(j + maxDistanceFromCenter + 1));
                class_265 voxelShape = class_259.method_1072((class_265)class_259.method_1078((class_238)box), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)), (class_247)class_247.field_16886);
                AlternateJigsawGenerator.generate(context.comp_564(), size, useExpansionHack, chunkGenerator, structureTemplateManager, heightLimitView, (class_5819)chunkRandom, (class_2378<class_3785>)registry, poolStructurePiece, list, voxelShape);
                Objects.requireNonNull(collector);
                list.forEach(arg_0 -> ((class_6626)collector).method_35462(arg_0));
            }
        }));
    }

    private static Optional<class_2338> findStartingJigsawPos(class_3784 pool, class_2960 id, class_2338 pos, class_2470 rotation, class_3485 structureManager, class_2919 random) {
        List list = pool.method_16627(structureManager, pos, rotation, (class_5819)random);
        Optional<class_2338> optional = Optional.empty();
        for (class_3499.class_3501 structureBlockInfo : list) {
            class_2960 identifier;
            if (structureBlockInfo.comp_1343() == null || !id.equals((Object)(identifier = class_2960.method_12829((String)structureBlockInfo.comp_1343().method_10558("name"))))) continue;
            optional = Optional.of(structureBlockInfo.comp_1341());
            break;
        }
        return optional;
    }

    private static void generate(class_7138 noiseConfig, int maxSize, boolean useExpansionHack, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 heightLimitView, class_5819 random, class_2378<class_3785> structurePoolRegistry, class_3790 firstPiece, List<class_3790> pieces, class_265 pieceShape) {
        StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator(structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        structurePoolGenerator.structurePieces.addLast(new ShapedPoolStructurePiece(firstPiece, (MutableObject<class_265>)new MutableObject((Object)pieceShape), 0));
        while (!structurePoolGenerator.structurePieces.isEmpty()) {
            ShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
            structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, useExpansionHack, heightLimitView, noiseConfig);
        }
    }

    static final class StructurePoolGenerator {
        private final class_2378<class_3785> registry;
        private final int maxSize;
        private final class_2794 chunkGenerator;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> piecesToPlace;
        private final class_5819 random;
        private final Map<ExclusivePoolElement, Integer> elementsToCounts;
        final Deque<ShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();

        StructurePoolGenerator(class_2378<class_3785> registry, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> children, class_5819 random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.piecesToPlace = children;
            this.random = random;
            this.elementsToCounts = new HashMap<ExclusivePoolElement, Integer>();
        }

        void generatePiece(class_3790 parentPiece, MutableObject<class_265> voxelShape, int depth, boolean useExpansionHack, class_5539 world, class_7138 noiseConfig) {
            class_3784 anchorElement = parentPiece.method_16644();
            MutableObject<class_265> parentShape = new MutableObject<class_265>();
            for (class_3499.class_3501 anchorJigsawInfo : anchorElement.method_16627(this.structureTemplateManager, parentPiece.method_16648(), parentPiece.method_16888(), this.random)) {
                MutableObject<class_265> childShape;
                class_3341 parentBoundingBox = parentPiece.method_14935();
                class_2338 candidateConnectorPos = anchorJigsawInfo.comp_1341().method_10093(class_3748.method_26378((class_2680)anchorJigsawInfo.comp_1342()));
                int k = -1;
                class_6880<class_3785> poolEntry = this.getStructurePoolEntry(StructurePoolGenerator.getPoolKey(anchorJigsawInfo));
                if (poolEntry == null) {
                    return;
                }
                boolean connectorInParentBoundingBox = parentBoundingBox.method_14662((class_2382)candidateConnectorPos);
                if (connectorInParentBoundingBox) {
                    childShape = parentShape;
                    if (parentShape.getValue() == null) {
                        parentShape.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)parentBoundingBox)));
                    }
                } else {
                    childShape = voxelShape;
                }
                this.findAndTestChildCandidates(poolEntry, this.collectChildCandidateList(StructurePoolGenerator.getPoolKey(anchorJigsawInfo), depth, true), parentPiece, anchorJigsawInfo, childShape, k, depth, useExpansionHack, world, noiseConfig);
            }
        }

        private void findAndTestChildCandidates(class_6880<class_3785> fallbackEntry, List<class_3784> childCandidates, class_3790 parentPiece, class_3499.class_3501 anchorJigsawInfo, MutableObject<class_265> mutableObject2, int k, int depth, boolean useExpansionHack, class_5539 world, class_7138 noiseConfig) {
            if (childCandidates.isEmpty()) {
                return;
            }
            boolean foundChild = this.findValidChildPiece(childCandidates, parentPiece, anchorJigsawInfo, mutableObject2, k, depth, useExpansionHack, world, noiseConfig);
            if (!foundChild) {
                this.findAndTestChildCandidates((class_6880<class_3785>)((class_3785)fallbackEntry.comp_349()).method_46736(), this.collectChildCandidateList((class_5321<class_3785>)((class_3785)fallbackEntry.comp_349()).method_46736().method_40230().orElse(class_5468.field_26254), depth, false), parentPiece, anchorJigsawInfo, mutableObject2, k, depth, useExpansionHack, world, noiseConfig);
            }
        }

        private List<class_3784> collectChildCandidateList(class_5321<class_3785> poolKey, int depth, boolean firstIteration) {
            class_6880 pool = (class_6880)this.registry.method_40264(poolKey).orElseThrow();
            if (depth == this.maxSize && firstIteration) {
                pool = ((class_3785)pool.comp_349()).method_46736();
            }
            if (pool.method_40230().isPresent() && pool.method_40230().get() == class_5468.field_26254) {
                return List.of();
            }
            if (pool == ((class_3785)pool.comp_349()).method_46736()) {
                LithostitchedCommon.LOGGER.warn("Template pool fallback references itself: {}", (Object)pool.method_40230().map(class_5321::toString).orElse("<unregistered>"));
                return List.of();
            }
            class_6032 structurePoolElementsList = ((StructurePoolAccess)pool.comp_349()).getLithostitchedTemplates().method_35088();
            ArrayList<class_3784> elements = new ArrayList<class_3784>(structurePoolElementsList.method_35094().filter(element -> {
                GuaranteedPoolElement guaranteedElement;
                return element instanceof GuaranteedPoolElement && (guaranteedElement = (GuaranteedPoolElement)((Object)element)).minDepth() <= depth;
            }).toList());
            elements.addAll(structurePoolElementsList.method_35094().filter(element -> !elements.contains(element)).toList());
            return elements.stream().toList();
        }

        private boolean findValidChildPiece(List<class_3784> childCandidates, class_3790 parentPiece, class_3499.class_3501 anchorJigsawInfo, MutableObject<class_265> mutableObject2, int k, int depth, boolean useExpansionHack, class_5539 world, class_7138 noiseConfig) {
            class_2338 anchorPos = anchorJigsawInfo.comp_1341();
            class_2338 candidateConnectorPos = anchorPos.method_10093(class_3748.method_26378((class_2680)anchorJigsawInfo.comp_1342()));
            int parentMinY = parentPiece.method_14935().method_35416();
            int anchorDistanceToFloor = anchorPos.method_10264() - parentMinY;
            class_3785.class_3786 parentProjection = parentPiece.method_16644().method_16624();
            boolean parentRigid = parentProjection == class_3785.class_3786.field_16687;
            for (class_3784 candidateElement : childCandidates.stream().distinct().toList()) {
                class_3784 processedCandidateElement;
                if (candidateElement == class_3777.field_16663) {
                    return true;
                }
                if (candidateElement instanceof ExclusivePoolElement) {
                    ExclusivePoolElement exclusiveElement = (ExclusivePoolElement)candidateElement;
                    if (exclusiveElement instanceof LimitedPoolElement) {
                        LimitedPoolElement limitedElement = (LimitedPoolElement)exclusiveElement;
                        if (!this.elementsToCounts.containsKey((Object)limitedElement)) {
                            this.elementsToCounts.put(limitedElement, limitedElement.limit());
                        }
                        if (this.elementsToCounts.get((Object)limitedElement) < 1) {
                            continue;
                        }
                    } else if (exclusiveElement instanceof GuaranteedPoolElement) {
                        GuaranteedPoolElement guaranteedElement = (GuaranteedPoolElement)exclusiveElement;
                        if (!this.elementsToCounts.containsKey((Object)guaranteedElement)) {
                            this.elementsToCounts.put(guaranteedElement, 0);
                        }
                        if (this.elementsToCounts.get((Object)guaranteedElement) >= guaranteedElement.count()) continue;
                    }
                    processedCandidateElement = exclusiveElement.delegate();
                } else {
                    processedCandidateElement = candidateElement;
                }
                for (class_2470 rotation : class_2470.method_16547((class_5819)this.random)) {
                    List connectorJigsaws = processedCandidateElement.method_16627(this.structureTemplateManager, class_2338.field_10980, rotation, this.random);
                    class_3341 connectorBoundingBox = processedCandidateElement.method_16628(this.structureTemplateManager, class_2338.field_10980, rotation);
                    int l = useExpansionHack && connectorBoundingBox.method_14660() <= 16 ? connectorJigsaws.stream().mapToInt(blockInfo -> {
                        if (!connectorBoundingBox.method_14662((class_2382)blockInfo.comp_1341().method_10093(class_3748.method_26378((class_2680)blockInfo.comp_1342())))) {
                            return 0;
                        }
                        class_5321<class_3785> registryKey2 = StructurePoolGenerator.getPoolKey(blockInfo);
                        Optional optional1 = this.registry.method_40264(registryKey2);
                        Optional<class_6880> optional2 = optional1.map(entry -> ((class_3785)entry.comp_349()).method_46736());
                        int i2 = optional1.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                        int j2 = optional2.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                        return Math.max(i2, j2);
                    }).max().orElse(0) : 0;
                    for (class_3499.class_3501 connectorJigsawInfo : connectorJigsaws) {
                        int t;
                        int r;
                        int p;
                        if (!class_3748.method_16546((class_3499.class_3501)anchorJigsawInfo, (class_3499.class_3501)connectorJigsawInfo)) continue;
                        class_2338 connectorPos = connectorJigsawInfo.comp_1341();
                        class_2338 blockPos5 = candidateConnectorPos.method_10059((class_2382)connectorPos);
                        class_3341 blockBox3 = processedCandidateElement.method_16628(this.structureTemplateManager, blockPos5, rotation);
                        int m = blockBox3.method_35416();
                        class_3785.class_3786 connectorProjection = processedCandidateElement.method_16624();
                        boolean connectorProjectionRigid = connectorProjection == class_3785.class_3786.field_16687;
                        int connectorY = connectorPos.method_10264();
                        int o = anchorDistanceToFloor - connectorY + class_3748.method_26378((class_2680)anchorJigsawInfo.comp_1342()).method_10164();
                        if (parentRigid && connectorProjectionRigid) {
                            p = parentMinY + o;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.method_20402(anchorPos.method_10263(), anchorPos.method_10260(), class_2902.class_2903.field_13194, world, noiseConfig);
                            }
                            p = k - connectorY;
                        }
                        int q = p - m;
                        class_3341 blockBox4 = blockBox3.method_19311(0, q, 0);
                        class_2338 blockPos6 = blockPos5.method_10069(0, q, 0);
                        if (l > 0) {
                            r = Math.max(l + 1, blockBox4.method_35419() - blockBox4.method_35416());
                            blockBox4.method_34389(new class_2338(blockBox4.method_35415(), blockBox4.method_35416() + r, blockBox4.method_35417()));
                        }
                        if (class_259.method_1074((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                        if (candidateElement instanceof ExclusivePoolElement) {
                            ExclusivePoolElement exclusiveElement = (ExclusivePoolElement)candidateElement;
                            if (exclusiveElement instanceof LimitedPoolElement) {
                                LimitedPoolElement limitedElement = (LimitedPoolElement)exclusiveElement;
                                this.elementsToCounts.put(limitedElement, this.elementsToCounts.get((Object)limitedElement) - 1);
                            } else if (exclusiveElement instanceof GuaranteedPoolElement) {
                                GuaranteedPoolElement guaranteedElement = (GuaranteedPoolElement)exclusiveElement;
                                this.elementsToCounts.put(guaranteedElement, this.elementsToCounts.get((Object)guaranteedElement) + 1);
                            }
                        }
                        mutableObject2.setValue((Object)class_259.method_1082((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4)), (class_247)class_247.field_16886));
                        r = parentPiece.method_16646();
                        int s = connectorProjectionRigid ? r - o : processedCandidateElement.method_19308();
                        class_3790 poolStructurePiece = new class_3790(this.structureTemplateManager, processedCandidateElement, blockPos6, s, rotation, blockBox4);
                        if (parentRigid) {
                            t = parentMinY + anchorDistanceToFloor;
                        } else if (connectorProjectionRigid) {
                            t = p + connectorY;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.method_20402(anchorPos.method_10263(), anchorPos.method_10260(), class_2902.class_2903.field_13194, world, noiseConfig);
                            }
                            t = k + o / 2;
                        }
                        parentPiece.method_16647(new class_3780(candidateConnectorPos.method_10263(), t - anchorDistanceToFloor + r, candidateConnectorPos.method_10260(), o, connectorProjection));
                        poolStructurePiece.method_16647(new class_3780(anchorPos.method_10263(), t - connectorY + s, anchorPos.method_10260(), -o, parentProjection));
                        this.piecesToPlace.add((class_3790)poolStructurePiece);
                        if (depth + 1 <= this.maxSize) {
                            this.structurePieces.addLast(new ShapedPoolStructurePiece(poolStructurePiece, mutableObject2, depth + 1));
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private class_6880<class_3785> getStructurePoolEntry(class_5321<class_3785> key) {
            Optional optional = this.registry.method_40264(key);
            if (optional.isEmpty()) {
                LithostitchedCommon.LOGGER.warn("Non-existent template pool reference: {}", (Object)key.method_29177());
            } else {
                class_6880 regularPool = (class_6880)optional.get();
                if (((class_3785)regularPool.comp_349()).method_16632() == 0) {
                    if (!regularPool.method_40225(class_5468.field_26254)) {
                        LithostitchedCommon.LOGGER.warn("Empty template pool reference: {}", (Object)key.method_29177());
                    }
                } else {
                    return regularPool;
                }
            }
            return null;
        }

        private static class_5321<class_3785> getPoolKey(class_3499.class_3501 blockInfo) {
            return class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)new class_2960(blockInfo.comp_1343().method_10558("pool")));
        }
    }

    private record ShapedPoolStructurePiece(class_3790 piece, MutableObject<class_265> pieceShape, int currentSize) {
    }
}

