/*
 * Decompiled with CFR 0.152.
 */
package io.github.hornster.itemfig.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.hornster.itemfig.ItemFig;
import io.github.hornster.itemfig.api.serialization.config.ConfigObj;
import io.github.hornster.itemfig.api.serialization.config.ConfigObjAdapterConfig;
import io.github.hornster.itemfig.serialization.SerializationHelper;
import io.github.hornster.itemfig.serialization.config.ConfigObjAdapter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;

public class SerializationManager {
    private final String _registeredObjectsFieldName = "registeredObjects";
    private final Map<String, ConfigObj> _registeredObjects = new LinkedHashMap<String, ConfigObj>();
    private final Map<Type, ConfigObjAdapter<?>> _registeredObjectsAdapters = new HashMap();
    private final String _jsonPath = System.getProperty("user.dir") + File.separator + "config" + File.separator;
    private String _jsonFileName = "itemfig-mod-config";
    private final String _jsonExtension = ".json";
    private Consumer<String> _configSaveErrHandler;
    private Consumer<String> _configSaveWarnHandler;
    private Consumer<String> _configReadErrHandler;
    private Consumer<String> _configReadWarnHandler;
    private boolean _jsonDeserializationError = false;
    public boolean _forceConfigSave = false;
    public boolean _updateConfigSave = true;
    public boolean _recreateConfig = false;

    public void registerObject(ConfigObj object, ConfigObjAdapterConfig<?> adapter) {
        this._registeredObjects.put(object.getConfigObjId(), object);
        ConfigObjAdapter objAdapter = new ConfigObjAdapter(adapter);
        this._registeredObjectsAdapters.put(object.getConfigObjType(), objAdapter);
    }

    public void registerObjects(List<Pair<ConfigObj, ConfigObjAdapterConfig<?>>> objects) {
        for (Pair<ConfigObj, ConfigObjAdapterConfig<?>> obj : objects) {
            ConfigObj configObj = (ConfigObj)obj.getKey();
            this._registeredObjects.put(configObj.getConfigObjId(), configObj);
            ConfigObjAdapter objAdapter = new ConfigObjAdapter((ConfigObjAdapterConfig)obj.getValue());
            this._registeredObjectsAdapters.put(configObj.getConfigObjType(), objAdapter);
        }
    }

    public void registerSaveErrorHandler(Consumer<String> handler) {
        this._configSaveErrHandler = handler;
    }

    public void registerSaveWarningHandler(Consumer<String> handler) {
        this._configSaveWarnHandler = handler;
    }

    public void registerReadErrorHandler(Consumer<String> handler) {
        this._configReadErrHandler = handler;
    }

    public void registerReadWarningHandler(Consumer<String> handler) {
        this._configReadWarnHandler = handler;
    }

    public void setConfigFileName(String name) {
        this._jsonFileName = name;
    }

    public String getConfigFileName() {
        this.chkIfExtensionProvided();
        return this._jsonFileName;
    }

    public String getConfigPath() {
        this.chkIfExtensionProvided();
        return this._jsonPath;
    }

    private void reportDeserializationError(String msg) {
        this._jsonDeserializationError = true;
        if (this._configReadErrHandler != null) {
            this._configReadErrHandler.accept(msg);
        }
        ItemFig.LOGGER.error(msg);
    }

    private void reportDeserializationWarning(String msg) {
        if (this._configReadWarnHandler != null) {
            this._configReadWarnHandler.accept(msg);
        }
        ItemFig.LOGGER.warn(msg);
    }

    private void reportSerializationWarning(String msg) {
        if (this._configSaveWarnHandler != null) {
            this._configSaveWarnHandler.accept(msg);
        }
        ItemFig.LOGGER.warn(msg);
    }

    private void reportSerializationError(String msg) {
        if (this._configSaveErrHandler != null) {
            this._configSaveErrHandler.accept(msg);
        }
        ItemFig.LOGGER.error(msg);
    }

    private void chkIfExtensionProvided() {
        if (!this._jsonFileName.contains(".json")) {
            this._jsonFileName = this._jsonFileName + ".json";
        }
    }

    private void deserializeFile(Gson gson, String jsonString) {
        JsonObject jsonConfigObj;
        JsonObject jsonRegisteredObjects;
        JsonElement jsonConfigElement = (JsonElement)gson.fromJson(jsonString, JsonElement.class);
        if (!jsonConfigElement.isJsonObject()) {
            this.reportDeserializationError("Base json element is not a json object!");
        }
        if ((jsonRegisteredObjects = (jsonConfigObj = jsonConfigElement.getAsJsonObject()).getAsJsonObject("registeredObjects")) == null) {
            this.reportDeserializationWarning("Read config is empty! You ought to run the deserialization with the config recreation flag set to true.");
            return;
        }
        Map<String, JsonElement> jsonRegisteredObjectsSet = SerializationHelper.getAsMap(jsonRegisteredObjects);
        if (jsonRegisteredObjectsSet.size() == 0) {
            this.reportDeserializationWarning("Read config is empty! You ought to run the deserialization with the config recreation flag set to true.");
            return;
        }
        Set<String> keys = jsonRegisteredObjectsSet.keySet();
        for (String key : keys) {
            JsonElement jsonElement = jsonRegisteredObjectsSet.get(key);
            if (!jsonElement.isJsonObject()) {
                this.reportDeserializationWarning("Element with key " + key + " is not a valid json object! Skipping.");
                continue;
            }
            if (!this._registeredObjects.containsKey(key)) {
                this.reportDeserializationWarning("Element with key " + key + " does not have a registered data object! Skipping.");
                continue;
            }
            ConfigObj registeredObject = this._registeredObjects.get(key);
            ConfigObj deserializedConfigObj = registeredObject.DeserializeConfigObj(gson, jsonElement);
            this._registeredObjects.replace(key, deserializedConfigObj);
        }
    }

    private void chkDefaultValues() {
        Collection<ConfigObj> registeredObjectsCollection = this._registeredObjects.values();
        for (ConfigObj registeredObj : registeredObjectsCollection) {
            registeredObj.chkDefaultValues();
        }
    }

    private void recreateConfig(Gson gson) {
        this.chkDefaultValues();
        Path path = Paths.get(this.getConfigPath() + this.getConfigFileName(), new String[0]);
        try {
            Files.delete(path);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException ex) {
            this.reportSerializationError(ex.getMessage());
        }
        this.saveConfig();
    }

    public void readConfig() {
        block4: {
            this.chkIfExtensionProvided();
            this._jsonDeserializationError = false;
            Gson gsonObj = this.getGson();
            String configStr = "";
            this.chkDefaultValues();
            if (this._recreateConfig) {
                this.recreateConfig(gsonObj);
                return;
            }
            try {
                String filePath = this.getConfigPath() + this.getConfigFileName();
                configStr = this.readFile(filePath);
                this.deserializeFile(gsonObj, configStr);
            }
            catch (IOException ex) {
                if (this._configReadErrHandler == null) break block4;
                this._configReadErrHandler.accept(ex.getMessage());
            }
        }
        if (this._forceConfigSave || this._updateConfigSave && !this._jsonDeserializationError) {
            this.saveConfig();
        }
    }

    public ConfigObj getItemConfig(String itemId) {
        ConfigObj object = this._registeredObjects.get(itemId);
        return object;
    }

    public <T extends ConfigObj> T getItemConfigAutoCast(String itemId) {
        ConfigObj object = this._registeredObjects.get(itemId);
        return (T)object;
    }

    private String readFile(String fileName) throws IOException {
        String result = "";
        Path path = Paths.get(fileName, new String[0]);
        List<String> readLines = Files.readAllLines(path);
        StringBuilder sb = new StringBuilder();
        for (String readLine : readLines) {
            sb.append(readLine);
        }
        result = sb.toString();
        return result;
    }

    private void saveConfig() {
        block2: {
            try {
                this.saveConfigPerform();
            }
            catch (IOException ex) {
                if (this._configSaveErrHandler == null) break block2;
                this._configSaveErrHandler.accept(ex.getMessage());
            }
        }
    }

    private Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        for (Type adapterType : this._registeredObjectsAdapters.keySet()) {
            gsonBuilder.registerTypeAdapter(adapterType, this._registeredObjectsAdapters.get(adapterType));
        }
        return gsonBuilder.create();
    }

    private void saveConfigPerform() throws IOException {
        Gson gson = this.getGson();
        JsonObject rootJsonObj = new JsonObject();
        JsonElement configMapElement = gson.toJsonTree(new HashMap());
        JsonObject configMapJsonObj = configMapElement.getAsJsonObject();
        Map<String, JsonElement> configMapObj = SerializationHelper.getAsMap(configMapJsonObj);
        this._registeredObjects.forEach((key, configObj) -> {
            JsonElement serializedObj = gson.toJsonTree(configObj);
            configMapObj.put((String)key, serializedObj);
        });
        JsonElement modifiedConfigMapJsonElement = gson.toJsonTree(configMapObj);
        rootJsonObj.add("registeredObjects", modifiedConfigMapJsonElement);
        String jsonData = gson.toJson((JsonElement)rootJsonObj);
        if (this._registeredObjects.size() == 0) {
            this.reportSerializationWarning("Saved config is empty! You ought to register something before calling reading methods and set recreation flag to true.");
        }
        String configPath = this.getConfigPath();
        new File(configPath).mkdirs();
        FileWriter fileWriter = new FileWriter(configPath + this.getConfigFileName());
        fileWriter.write(jsonData);
        fileWriter.close();
    }
}

