/*
 * Decompiled with CFR 0.152.
 */
package io.github.hornster.itemfig.serialization.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.hornster.itemfig.ItemFig;
import io.github.hornster.itemfig.api.serialization.config.ConfigObj;
import io.github.hornster.itemfig.api.serialization.config.ConfigObjAdapterConfig;
import io.github.hornster.itemfig.serialization.SerializationHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConfigObjAdapter<T extends ConfigObj>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private ConfigObjAdapterConfig<T> adapterConfig;

    public ConfigObjAdapter(ConfigObjAdapterConfig<T> adapterConfig) {
        this.adapterConfig = adapterConfig;
    }

    public JsonElement serialize(T src, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        List<Field> fields = this.getFields();
        for (Field field : fields) {
            try {
                if (field.getType().equals(Type.class)) continue;
                SerializationHelper.addProperty(field, jsonObject, src);
            }
            catch (IllegalAccessException ex) {
                String errMsg = "Could not access the field " + field.getName() + " during serialization! " + ex.getMessage();
                System.out.println(errMsg);
                ItemFig.LOGGER.error(errMsg);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ItemFig.LOGGER.error(ex.getMessage());
            }
        }
        return jsonObject;
    }

    protected List<Field> getFields() {
        Class trueConfigObjClass = this.adapterConfig.getConfigObjClass();
        return this.getFields(trueConfigObjClass);
    }

    protected Constructor<T> getConstructorForDeserialization() throws NoSuchMethodException {
        return this.adapterConfig.getConstructorForDeserialization();
    }

    protected List<Field> getFields(Class checkedClass) {
        if (checkedClass == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(this.getFields(checkedClass.getSuperclass()));
        List<Field> checkedClassFields = Arrays.stream(checkedClass.getDeclaredFields()).toList();
        result.addAll(checkedClassFields);
        return result;
    }

    public T deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        List<Field> fields = this.getFields();
        Constructor<T> cons = null;
        String myId = jsonObject.getAsJsonPrimitive("_myID").getAsString();
        try {
            cons = this.getConstructorForDeserialization();
        }
        catch (NoSuchMethodException ex) {
            String errMsg = "Constructor for class" + type.getTypeName() + "not found! Config type has to have a public constructor that accepts one string type! Additional info: " + ex.getMessage();
            System.out.println(errMsg);
            ItemFig.LOGGER.error(errMsg);
            return null;
        }
        ConfigObj configObject = null;
        try {
            configObject = (ConfigObj)cons.newInstance(myId);
        }
        catch (Exception ex) {
            String errMsg = "Could not instantiate object of type " + type.getTypeName() + "! The constructor that hassingle String type must be public! Additional info: " + ex.getMessage();
            System.out.println(errMsg);
            ItemFig.LOGGER.error(errMsg);
            return null;
        }
        configObject.chkDefaultValues();
        for (Field field : fields) {
            try {
                if (field.getType().equals(Type.class)) continue;
                SerializationHelper.readProperty(field, jsonObject, configObject);
            }
            catch (IllegalAccessException ex) {
                String errMsg = "Could not access the field " + field.getName() + " during serialization! " + ex.getMessage();
                System.out.println(errMsg);
                ItemFig.LOGGER.error(errMsg);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ItemFig.LOGGER.error(ex.getMessage());
            }
        }
        return (T)configObject;
    }
}

