/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.blocks;

import com.google.gson.JsonObject;
import com.telepathicgrunt.the_bumblezone.client.blocks.ConnectedTexture;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmState;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3518;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class ConnectedBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> BASE_QUAD = List.of(AthenaQuad.withSprite((int)0));
    private static final List<AthenaQuad> FRONT_QUAD = List.of(AthenaQuad.withSprite((int)1));
    private static final AthenaQuad TOP_LEFT_QUAD = AthenaQuad.withSprite((int)2);
    private static final AthenaQuad TOP_RIGHT_QUAD = AthenaQuad.withSprite((int)3);
    private static final AthenaQuad BOTTOM_LEFT_QUAD = AthenaQuad.withSprite((int)4);
    private static final AthenaQuad BOTTOM_RIGHT_QUAD = AthenaQuad.withSprite((int)5);
    private final EnumMap<ConnectedTexture, class_4730> materials;
    private final BiPredicate<class_2680, class_2680> connectTo;

    public ConnectedBlockModel(EnumMap<ConnectedTexture, class_4730> materials, BiPredicate<class_2680, class_2680> connectTo) {
        this.materials = materials;
        this.connectTo = connectTo;
    }

    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, class_2680 state, class_2338 pos, class_2350 direction) {
        if (CtmUtils.checkRelative((AppearanceAndTintGetter)level, (class_2680)state, (class_2338)pos, (class_2350)direction)) {
            return List.of();
        }
        CtmState ctm = CtmState.from((AppearanceAndTintGetter)level, (class_2680)state, (class_2338)pos, (class_2350)direction, (CtmState.ConnectionCheck)CtmUtils.check((AppearanceAndTintGetter)level, (class_2680)state, (class_2338)pos, (class_2350)direction, this.connectTo));
        ArrayList<AthenaQuad> quads = new ArrayList<AthenaQuad>(this.isFacing(state, direction) ? FRONT_QUAD : BASE_QUAD);
        if (ctm.up() || ctm.upLeft() || ctm.left()) {
            quads.add(TOP_LEFT_QUAD);
        }
        if (ctm.up() || ctm.upRight() || ctm.right()) {
            quads.add(TOP_RIGHT_QUAD);
        }
        if (ctm.down() || ctm.downLeft() || ctm.left()) {
            quads.add(BOTTOM_LEFT_QUAD);
        }
        if (ctm.down() || ctm.downRight() || ctm.right()) {
            quads.add(BOTTOM_RIGHT_QUAD);
        }
        return quads;
    }

    private boolean isFacing(class_2680 state, class_2350 direction) {
        return state.method_28498((class_2769)class_2741.field_12525) && ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153() == direction && this.materials.containsKey((Object)ConnectedTexture.FRONT);
    }

    public Map<class_2350, List<AthenaQuad>> getDefaultQuads(@Nullable class_2350 direction) {
        return direction == null ? Map.of() : Map.of(direction, BASE_QUAD);
    }

    public Int2ObjectMap<class_1058> getTextures(Function<class_4730, class_1058> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (ConnectedTexture value : ConnectedTexture.values()) {
            textures.put(value.ordinal(), (Object)getter.apply(this.materials.get((Object)value)));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        public Supplier<AthenaBlockModel> create(JsonObject json) {
            BiPredicate conditions = CtmUtils.parseCondition((JsonObject)json);
            EnumMap materials = new EnumMap(ConnectedTexture.class);
            JsonObject textures = class_3518.method_15296((JsonObject)json, (String)"textures");
            ConnectedTexture.list().forEach(texture -> texture.read(materials, textures));
            return () -> new ConnectedBlockModel(materials, conditions);
        }
    }
}

