/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.items.BuzzingBriefcase;
import com.telepathicgrunt.the_bumblezone.menus.BuzzingBriefcaseMenu;
import com.telepathicgrunt.the_bumblezone.mixin.client.EntityRenderersAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityAccessor;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3685;
import net.minecraft.class_4466;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5617;
import net.minecraft.class_759;
import net.minecraft.class_7923;
import net.minecraft.class_897;

public class BuzzingBriefcaseScreen
extends class_465<BuzzingBriefcaseMenu> {
    private static final class_2960 CONTAINER_BACKGROUND = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/background.png");
    private static final class_2960 BEE_SLOT_BACKGROUND = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_slots.png");
    private static final class_2960 GENERAL_ICONS = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/general_icons.png");
    private static final class_2960 BEE_VANILLA_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_vanilla.png");
    private static final class_2960 BEE_BASE_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_base_layer.png");
    private static final class_2960 BEE_PRIMARY_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_primary_layer.png");
    private static final class_2960 BEE_SECONDARY_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_secondary_layer.png");
    private static final class_2960 BEE_STINGER_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_stinger.png");
    private static final class_2960 BEE_POLLEN_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_pollen.png");
    private static final class_2960 BEE_BABY_BASE_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_baby_base_layer.png");
    private static final class_2960 BEE_BABY_PRIMARY_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_baby_primary_layer.png");
    private static final class_2960 BEE_BABY_SECONDARY_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_baby_secondary_layer.png");
    private static final class_2960 BEE_BABY_STINGER_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_baby_stinger.png");
    private static final class_2960 BEE_BABY_POLLEN_ICON = new class_2960("the_bumblezone", "textures/gui/buzzing_briefcase/bee_icon_baby_pollen.png");
    private static final int NORMAL_PRIMARY_COLOR = 15046912;
    private static final int NORMAL_SECONDARY_COLOR = 2298112;
    private static final int MISSING_PRIMARY_COLOR = 0;
    private static final int MISSING_SECONDARY_COLOR = 0xF200FF;
    private static final int[] IGNORE_COLORS = new int[]{8178129, 1973800, 3156791, 0xF7FDFD, 15856352, 6238757};
    private static final float SCALE = 1.25f;
    private static final int MENU_HEIGHT = 217;
    private static final int MENU_WIDTH = 382;
    private static final int MAX_ROW_LENGTH = 7;
    private final List<BeeState> BEE_INVENTORY = new ArrayList<BeeState>();
    private final class_1661 inventory;
    private class_2487 cachedBriefcaseTag;

    public BuzzingBriefcaseScreen(BuzzingBriefcaseMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.field_2792 = 240;
        this.field_2779 = 126;
        this.field_25267 = 75;
        this.field_25268 = -38;
        this.inventory = playerInventory;
    }

    protected void method_25426() {
        this.field_2776 = (this.getTrueWidth() - this.field_2792) / 2;
        this.field_2800 = (this.getTrueHeight() - this.field_2779) / 2;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_1799 briefcaseStack = (class_1799)((BuzzingBriefcaseMenu)this.field_2797).method_7602().get(0);
        if (!briefcaseStack.method_7960() && !briefcaseStack.method_7948().equals((Object)this.cachedBriefcaseTag)) {
            this.cachedBriefcaseTag = briefcaseStack.method_7948();
            List<class_1297> beesStored = BuzzingBriefcase.getBeesStored(this.inventory.field_7546.method_37908(), briefcaseStack, false);
            if (this.isDiffFoundInBeeList(beesStored)) {
                this.BEE_INVENTORY.clear();
                for (class_1297 entity : beesStored) {
                    if (!(entity instanceof class_4466)) continue;
                    class_4466 bee = (class_4466)entity;
                    bee.method_29922();
                    boolean pollinated = bee.method_21784();
                    ((BeeEntityInvoker)bee).callSetHasNectar(false);
                    try {
                        this.addBeeWithColor(bee);
                    }
                    catch (Exception e) {
                        this.BEE_INVENTORY.add(new BeeState(bee, 0, 0xF200FF));
                        Bumblezone.LOGGER.warn("Bumblezone Buzzing Briefcase Clientside: Error trying to dynamically get color for following bee -");
                        class_2487 tag = new class_2487();
                        bee.method_5647(tag);
                        Bumblezone.LOGGER.warn("Bee: {}", (Object)tag);
                    }
                    ((BeeEntityInvoker)bee).callSetHasNectar(pollinated);
                }
            }
        }
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.enableDepthTest();
        this.drawBeeSlots(guiGraphics, this.field_2776, this.field_2800, mouseX, mouseY);
    }

    private boolean isDiffFoundInBeeList(List<class_1297> beesStored) {
        if (this.BEE_INVENTORY.size() != beesStored.size()) {
            return true;
        }
        for (int i = 0; i < beesStored.size(); ++i) {
            class_1297 beeFound = beesStored.get(i);
            class_4466 beeSaved = this.BEE_INVENTORY.get(i).beeEntity();
            if (!(beeFound instanceof class_4466)) continue;
            class_4466 bee = (class_4466)beeFound;
            if (bee.method_21784() != beeSaved.method_21784()) {
                return true;
            }
            if (bee.method_6032() != beeSaved.method_6032()) {
                return true;
            }
            if (bee.method_6109() != beeSaved.method_6109()) {
                return true;
            }
            if (bee.method_21785() == beeSaved.method_21785()) continue;
            return true;
        }
        return false;
    }

    private void addBeeWithColor(class_4466 bee) throws IOException {
        int primaryColor = 15046912;
        int secondaryColor = 2298112;
        if (bee.method_5864() == class_1299.field_20346) {
            this.BEE_INVENTORY.add(new BeeState(bee, primaryColor, secondaryColor));
            return;
        }
        for (ModCompat compat : ModChecker.BEE_COLOR_COMPATS) {
            Pair<Integer, Integer> moddedBeeColors = compat.getModdedBeePrimaryAndSecondaryColors((class_1297)bee);
            if (moddedBeeColors == null) continue;
            this.BEE_INVENTORY.add(new BeeState(bee, (Integer)moddedBeeColors.getFirst(), (Integer)moddedBeeColors.getSecond()));
            return;
        }
        class_5617<?> rendererProvider = EntityRenderersAccessor.getPROVIDERS().get(bee.method_5864());
        if (rendererProvider != null) {
            class_897 entityRenderer = rendererProvider.create(new class_5617.class_5618(this.field_22787.method_1561(), this.field_22787.method_1480(), this.field_22787.method_1541(), new class_759(this.field_22787, this.field_22787.method_1561(), this.field_22787.method_1480()), this.field_22787.method_1478(), this.field_22787.method_31974(), this.field_22793));
            class_2960 textureLocation = entityRenderer.method_3931((class_1297)bee);
            int[] pixels = class_3685.method_16049((class_3300)this.field_22787.method_1478(), (class_2960)textureLocation);
            if (pixels == null || pixels.length == 0) {
                throw new RuntimeException("No pixels found for bee texture.");
            }
            ObjectArrayList colors = new ObjectArrayList();
            HashMap<Integer, Integer> deniedColors = new HashMap<Integer, Integer>();
            for (int pixel : pixels) {
                if (!((double)GeneralUtils.getAlpha(pixel) > 0.15)) continue;
                boolean isColorSimilarToDisallowedColors = false;
                for (int disallowedColor : IGNORE_COLORS) {
                    if (!GeneralUtils.isSimilarInColor(pixel, disallowedColor, 1)) continue;
                    isColorSimilarToDisallowedColors = true;
                    break;
                }
                if (!isColorSimilarToDisallowedColors) {
                    colors.add(pixel);
                    continue;
                }
                deniedColors.put(pixel, deniedColors.getOrDefault(pixel, 0) + 1);
            }
            Object object = deniedColors.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                if ((Integer)entry.getValue() < 200) continue;
                for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                    colors.add((Integer)entry.getKey());
                }
            }
            deniedColors.clear();
            ObjectArrayList originalColors = new ObjectArrayList();
            ObjectArrayList averagedColors = new ObjectArrayList();
            ObjectArrayList combinedColorCount = new ObjectArrayList();
            for (int i = colors.size() - 1; i >= 0; --i) {
                int color = (Integer)colors.remove(i);
                if (averagedColors.isEmpty()) {
                    originalColors.add(color);
                    averagedColors.add(color);
                    combinedColorCount.add(1);
                    continue;
                }
                boolean combined = false;
                for (int k = averagedColors.size() - 1; k >= 0; --k) {
                    int originalColor = (Integer)originalColors.get(k);
                    int averagedColor = (Integer)averagedColors.get(k);
                    if (!GeneralUtils.isSimilarInVisualColor(color, originalColor, 35, 80)) continue;
                    averagedColors.set(k, GeneralUtils.colorToInt((GeneralUtils.getRed(color) + GeneralUtils.getRed(averagedColor)) / 2, (GeneralUtils.getGreen(color) + GeneralUtils.getGreen(averagedColor)) / 2, (GeneralUtils.getBlue(color) + GeneralUtils.getBlue(averagedColor)) / 2));
                    combinedColorCount.set(k, (Integer)combinedColorCount.get(k) + 1);
                    combined = true;
                }
                if (combined) continue;
                originalColors.add(color);
                averagedColors.add(color);
                combinedColorCount.add(1);
            }
            int largestColorIndex1 = 0;
            int largestColorIndex2 = 0;
            for (int i = 0; i < combinedColorCount.size(); ++i) {
                if ((Integer)combinedColorCount.get(i) >= (Integer)combinedColorCount.get(largestColorIndex1)) {
                    if ((Integer)combinedColorCount.get(largestColorIndex1) >= (Integer)combinedColorCount.get(largestColorIndex2)) {
                        largestColorIndex2 = largestColorIndex1;
                    }
                    largestColorIndex1 = i;
                    continue;
                }
                if (largestColorIndex2 != largestColorIndex1 && (largestColorIndex1 == i || (Integer)combinedColorCount.get(i) < (Integer)combinedColorCount.get(largestColorIndex2))) continue;
                largestColorIndex2 = i;
            }
            primaryColor = (Integer)averagedColors.get(largestColorIndex1);
            secondaryColor = (Integer)averagedColors.get(largestColorIndex2);
        }
        this.BEE_INVENTORY.add(new BeeState(bee, primaryColor, secondaryColor));
    }

    protected void method_2389(class_332 guiGraphics, float partialtick, int x, int y) {
        int startX = (this.getTrueWidth() - 382) / 2;
        int startY = (this.getTrueHeight() - 217) / 2;
        RenderSystem.enableDepthTest();
        guiGraphics.method_25290(CONTAINER_BACKGROUND, startX, startY, 0.0f, 0.0f, 382, 434, 382, 434);
    }

    protected void method_2388(class_332 guiGraphics, int i, int j) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, 74, -38, 0xFFEFAF, true);
    }

    protected void renderButtonTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        int rowIndex = 0;
        int columnIndex = 0;
        for (BeeState beeState : this.BEE_INVENTORY) {
            class_2561 beeNormalAndCustomName;
            int xOffset = BuzzingBriefcaseScreen.getXOffset(rowIndex);
            int yOffset = BuzzingBriefcaseScreen.getYOffset(columnIndex);
            int mainX = this.field_2776 + xOffset;
            int mainY = this.field_2800 + yOffset;
            if (++rowIndex == 7) {
                rowIndex = 0;
                ++columnIndex;
            }
            if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 22.0 && (double)(mouseY - mainY) >= 0.0 && (double)(mouseY - mainY) < 22.0) {
                class_4466 beeEntity = beeState.beeEntity();
                beeNormalAndCustomName = beeEntity.method_5477();
                class_2561 beeNoneCustomName = beeEntity.method_5477();
                if (beeNoneCustomName != null && beeNoneCustomName.equals((Object)beeEntity.method_5797())) {
                    beeNoneCustomName = ((EntityAccessor)beeEntity).callGetTypeName();
                }
                boolean isNameAndTypeEqual = beeNoneCustomName != null && beeNoneCustomName.equals((Object)beeNormalAndCustomName);
                ArrayList<class_5250> toolTipComponents = new ArrayList<class_5250>();
                if (isNameAndTypeEqual) {
                    toolTipComponents.add(class_2561.method_43469((String)"item.the_bumblezone.buzzing_briefcase_bee_type", (Object[])new Object[]{beeNormalAndCustomName}).method_27692(class_124.field_1054));
                } else {
                    toolTipComponents.add(class_2561.method_43469((String)"item.the_bumblezone.buzzing_briefcase_bee_name", (Object[])new Object[]{beeNormalAndCustomName}));
                    toolTipComponents.add(class_2561.method_43469((String)"item.the_bumblezone.buzzing_briefcase_bee_type", (Object[])new Object[]{beeNoneCustomName}).method_27692(class_124.field_1054));
                }
                if (GeneralUtilsClient.isAdvancedToolTipActive()) {
                    toolTipComponents.add(class_2561.method_43469((String)"item.the_bumblezone.buzzing_briefcase_bee_registry_name", (Object[])new Object[]{class_7923.field_41177.method_10221((Object)beeState.beeEntity().method_5864())}).method_27692(class_124.field_1080).method_27692(class_124.field_1056));
                }
                guiGraphics.method_51437(this.field_22793, toolTipComponents, Optional.empty(), mouseX, mouseY);
                continue;
            }
            if ((double)(mouseX - (mainX + 22)) >= 0.0 && (double)(mouseX - (mainX + 22)) < 11.0 && (double)(mouseY - mainY) >= 0.0 && (double)(mouseY - mainY) < 11.0) {
                class_4466 beeEntity = beeState.beeEntity();
                beeNormalAndCustomName = beeEntity.method_5477();
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43469((String)"item.the_bumblezone.buzzing_briefcase_release", (Object[])new Object[]{beeNormalAndCustomName})), Optional.empty(), mouseX, mouseY);
                continue;
            }
            if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 11.0 && (double)(mouseY - (mainY + 22)) >= 0.0 && (double)(mouseY - (mainY + 22)) < 11.0) {
                if (!(beeState.beeEntity().method_6032() < beeState.beeEntity().method_6063())) continue;
                boolean hasHoneyBottleItem = this.inventory.method_7379(class_1802.field_20417.method_7854());
                if (hasHoneyBottleItem) {
                    guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_health_1"), class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_health_2")), Optional.empty(), mouseX, mouseY);
                    continue;
                }
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_health_missing_item")), Optional.empty(), mouseX, mouseY);
                continue;
            }
            if ((double)(mouseX - (mainX + 11)) >= 0.0 && (double)(mouseX - (mainX + 11)) < 11.0 && (double)(mouseY - (mainY + 22)) >= 0.0 && (double)(mouseY - (mainY + 22)) < 11.0) {
                if (!beeState.beeEntity().method_21785()) continue;
                boolean hasBeeStingerItem = this.inventory.method_7379(BzItems.BEE_STINGER.get().method_7854());
                if (hasBeeStingerItem) {
                    guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_stinger_1"), class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_stinger_2")), Optional.empty(), mouseX, mouseY);
                    continue;
                }
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_stinger_missing_item")), Optional.empty(), mouseX, mouseY);
                continue;
            }
            if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 11.0 && (double)(mouseY - (mainY + 33)) >= 0.0 && (double)(mouseY - (mainY + 33)) < 11.0) {
                if (!beeState.beeEntity().method_6109()) continue;
                boolean hasHoneyBottleItem = this.inventory.method_7379(class_1802.field_20417.method_7854());
                if (hasHoneyBottleItem) {
                    guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_grow_up_1"), class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_grow_up_2")), Optional.empty(), mouseX, mouseY);
                    continue;
                }
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_grow_up_missing_item")), Optional.empty(), mouseX, mouseY);
                continue;
            }
            if (!((double)(mouseX - (mainX + 11)) >= 0.0) || !((double)(mouseX - (mainX + 11)) < 11.0) || !((double)(mouseY - (mainY + 33)) >= 0.0) || !((double)(mouseY - (mainY + 33)) < 11.0) || !beeState.beeEntity().method_5864().method_20210(BzTags.BUZZING_BRIEFCASE_CAN_POLLINATE) || beeState.beeEntity().method_21784()) continue;
            boolean hasPollenPuffItem = this.inventory.method_7379(BzItems.POLLEN_PUFF.get().method_7854());
            if (hasPollenPuffItem) {
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_pollen_1"), class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_pollen_2")), Optional.empty(), mouseX, mouseY);
                continue;
            }
            guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43471((String)"item.the_bumblezone.buzzing_briefcase_pollen_missing_item")), Optional.empty(), mouseX, mouseY);
        }
    }

    private void drawBeeSlots(class_332 guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        boolean hasStingerItem = false;
        boolean hasHoneyBottleItem = false;
        boolean hasPollenPuffItem = false;
        if (!this.BEE_INVENTORY.isEmpty()) {
            hasStingerItem = this.inventory.method_7379(BzItems.BEE_STINGER.get().method_7854());
            hasHoneyBottleItem = this.inventory.method_7379(class_1802.field_20417.method_7854());
            hasPollenPuffItem = this.inventory.method_7379(BzItems.POLLEN_PUFF.get().method_7854());
        }
        int rowIndex = 0;
        int columnIndex = 0;
        for (int beeIndex = 0; beeIndex < 14; ++beeIndex) {
            int xOffset = BuzzingBriefcaseScreen.getXOffset(rowIndex);
            int yOffset = BuzzingBriefcaseScreen.getYOffset(columnIndex);
            int mainX = startX + xOffset;
            int mainY = startY + yOffset;
            if (++rowIndex == 7) {
                rowIndex = 0;
                ++columnIndex;
            }
            BeeState beeState = null;
            if (beeIndex < this.BEE_INVENTORY.size()) {
                beeState = this.BEE_INVENTORY.get(beeIndex);
            }
            RenderSystem.enableDepthTest();
            if (beeState == null) {
                guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX, mainY, 22.0f, 0.0f, 22, 22, 64, 64);
                guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX, mainY + 22, 22.0f, 22.0f, 11, 11, 64, 64);
                guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX + 11, mainY + 22, 22.0f, 22.0f, 11, 11, 64, 64);
                guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX, mainY + 33, 22.0f, 22.0f, 11, 11, 64, 64);
                guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX + 11, mainY + 33, 22.0f, 22.0f, 11, 11, 64, 64);
                continue;
            }
            BuzzingBriefcaseScreen.drawBeeSlot(guiGraphics, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderHealthButton(guiGraphics, mouseX, mouseY, hasHoneyBottleItem, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderStingerButton(guiGraphics, mouseX, mouseY, hasStingerItem, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderGrowUpButton(guiGraphics, mouseX, mouseY, hasHoneyBottleItem, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderPollenButton(guiGraphics, mouseX, mouseY, hasPollenPuffItem, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderReleaseButton(guiGraphics, mouseX, mouseY, mainX, mainY);
            this.renderButtonTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    private static void drawBeeSlot(class_332 guiGraphics, int mainX, int mainY, BeeState beeState) {
        guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX, mainY, 0.0f, 0.0f, 22, 22, 64, 64);
        boolean isBaby = beeState.beeEntity().method_6109();
        if (beeState.beeEntity().method_5864() == class_1299.field_20346) {
            int beeIconXOffset = 0;
            int beeIconYOffset = 0;
            if (isBaby) {
                beeIconYOffset += 16;
            }
            if (beeState.beeEntity().method_21785()) {
                beeIconXOffset += 16;
            }
            if (beeState.beeEntity().method_21784()) {
                beeIconXOffset += 32;
            }
            guiGraphics.method_25290(BEE_VANILLA_ICON, mainX + 3, mainY + 3, (float)beeIconXOffset, (float)beeIconYOffset, 16, 16, 64, 64);
        } else {
            guiGraphics.method_25290(isBaby ? BEE_BABY_BASE_ICON : BEE_BASE_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.method_51422((float)GeneralUtils.getRed(beeState.primaryColor()) / 255.0f, (float)GeneralUtils.getGreen(beeState.primaryColor()) / 255.0f, (float)GeneralUtils.getBlue(beeState.primaryColor()) / 255.0f, 1.0f);
            guiGraphics.method_25290(isBaby ? BEE_BABY_PRIMARY_ICON : BEE_PRIMARY_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.method_51422((float)GeneralUtils.getRed(beeState.secondaryColor()) / 255.0f, (float)GeneralUtils.getGreen(beeState.secondaryColor()) / 255.0f, (float)GeneralUtils.getBlue(beeState.secondaryColor()) / 255.0f, 1.0f);
            guiGraphics.method_25290(isBaby ? BEE_BABY_SECONDARY_ICON : BEE_SECONDARY_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (!beeState.beeEntity().method_21785()) {
                guiGraphics.method_25290(isBaby ? BEE_BABY_STINGER_ICON : BEE_STINGER_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (beeState.beeEntity().method_21784()) {
                guiGraphics.method_25290(isBaby ? BEE_BABY_POLLEN_ICON : BEE_POLLEN_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        float healthPercentage = Math.min(1.0f, beeState.beeEntity().method_6032() / beeState.beeEntity().method_6063());
        int barColor = class_3532.method_15369((float)(healthPercentage / 3.0f), (float)1.0f, (float)1.0f);
        int barWidth = (int)Math.max(1.0f, 16.0f * healthPercentage);
        guiGraphics.method_51739(class_1921.method_51785(), mainX + 3, mainY + 19, mainX + 3 + barWidth, mainY + 18, barColor | 0xFF000000);
    }

    private static void renderReleaseButton(class_332 guiGraphics, int mouseX, int mouseY, int mainX, int mainY) {
        if ((double)(mouseX - (mainX + 22)) >= 0.0 && (double)(mouseX - (mainX + 22)) < 11.0 && (double)(mouseY - mainY) >= 0.0 && (double)(mouseY - mainY) < 11.0) {
            guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX + 22, mainY, 33.0f, 33.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX + 22, mainY, 0.0f, 33.0f, 11, 11, 64, 64);
        }
    }

    private static void renderHealthButton(class_332 guiGraphics, int mouseX, int mouseY, boolean hasHoneyBottle, int mainX, int mainY, BeeState beeState) {
        if (beeState.beeEntity().method_6032() == beeState.beeEntity().method_6063()) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX, mainY + 22, 11.0f, 11.0f, 11, 11, 64, 64);
        } else if (!hasHoneyBottle) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX, mainY + 22, 22.0f, 11.0f, 11, 11, 64, 64);
        } else if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 11.0 && (double)(mouseY - (mainY + 22)) >= 0.0 && (double)(mouseY - (mainY + 22)) < 11.0) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX, mainY + 22, 33.0f, 11.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.method_25290(GENERAL_ICONS, mainX, mainY + 22, 0.0f, 11.0f, 11, 11, 64, 64);
        }
    }

    private static void renderStingerButton(class_332 guiGraphics, int mouseX, int mouseY, boolean hasStingerItem, int mainX, int mainY, BeeState beeState) {
        if (!beeState.beeEntity().method_21785()) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX + 11, mainY + 22, 11.0f, 0.0f, 11, 11, 64, 64);
        } else if (!hasStingerItem) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX + 11, mainY + 22, 22.0f, 0.0f, 11, 11, 64, 64);
        } else if ((double)(mouseX - (mainX + 11)) >= 0.0 && (double)(mouseX - (mainX + 11)) < 11.0 && (double)(mouseY - (mainY + 22)) >= 0.0 && (double)(mouseY - (mainY + 22)) < 11.0) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX + 11, mainY + 22, 33.0f, 0.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.method_25290(GENERAL_ICONS, mainX + 11, mainY + 22, 0.0f, 0.0f, 11, 11, 64, 64);
        }
    }

    private static void renderGrowUpButton(class_332 guiGraphics, int mouseX, int mouseY, boolean hasHoneyBottle, int mainX, int mainY, BeeState beeState) {
        if (!beeState.beeEntity().method_6109()) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX, mainY + 33, 11.0f, 33.0f, 11, 11, 64, 64);
        } else if (!hasHoneyBottle) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX, mainY + 33, 22.0f, 33.0f, 11, 11, 64, 64);
        } else if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 11.0 && (double)(mouseY - (mainY + 33)) >= 0.0 && (double)(mouseY - (mainY + 33)) < 11.0) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX, mainY + 33, 33.0f, 33.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.method_25290(GENERAL_ICONS, mainX, mainY + 33, 0.0f, 33.0f, 11, 11, 64, 64);
        }
    }

    private static void renderPollenButton(class_332 guiGraphics, int mouseX, int mouseY, boolean hasPollenPuff, int mainX, int mainY, BeeState beeState) {
        if (!beeState.beeEntity().method_5864().method_20210(BzTags.BUZZING_BRIEFCASE_CAN_POLLINATE)) {
            guiGraphics.method_25290(BEE_SLOT_BACKGROUND, mainX + 11, mainY + 33, 22.0f, 22.0f, 11, 11, 64, 64);
        } else if (beeState.beeEntity().method_21784()) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX + 11, mainY + 33, 11.0f, 22.0f, 11, 11, 64, 64);
        } else if (!hasPollenPuff) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX + 11, mainY + 33, 22.0f, 22.0f, 11, 11, 64, 64);
        } else if ((double)(mouseX - (mainX + 11)) >= 0.0 && (double)(mouseX - (mainX + 11)) < 11.0 && (double)(mouseY - (mainY + 33)) >= 0.0 && (double)(mouseY - (mainY + 33)) < 11.0) {
            guiGraphics.method_25290(GENERAL_ICONS, mainX + 11, mainY + 33, 33.0f, 22.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.method_25290(GENERAL_ICONS, mainX + 11, mainY + 33, 0.0f, 22.0f, 11, 11, 64, 64);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int rowIndex = 0;
        int columnIndex = 0;
        for (int beeIndex = 0; beeIndex < 14 && beeIndex < this.BEE_INVENTORY.size(); ++beeIndex) {
            class_1799 playerPollenStack;
            class_1799 playerHoneyBottleStack;
            int honeyBottleSlotIndex;
            class_4466 bee = this.BEE_INVENTORY.get(beeIndex).beeEntity();
            int xOffset = BuzzingBriefcaseScreen.getXOffset(rowIndex);
            int yOffset = BuzzingBriefcaseScreen.getYOffset(columnIndex);
            int mainX = this.field_2776 + xOffset;
            int mainY = this.field_2800 + yOffset;
            if (++rowIndex == 7) {
                rowIndex = 0;
                ++columnIndex;
            }
            if (mouseX - (double)(mainX + 22) >= 0.0 && mouseX - (double)(mainX + 22) < 11.0 && mouseY - (double)mainY >= 0.0 && mouseY - (double)mainY < 11.0) {
                this.sendButtonPressToMenu(beeIndex * 5 + 0);
                continue;
            }
            if (mouseX - (double)mainX >= 0.0 && mouseX - (double)mainX < 11.0 && mouseY - (double)(mainY + 22) >= 0.0 && mouseY - (double)(mainY + 22) < 11.0) {
                if (!(bee.method_6032() < bee.method_6063())) continue;
                this.sendButtonPressToMenu(beeIndex * 5 + 1);
                honeyBottleSlotIndex = this.inventory.method_7395(class_1802.field_20417.method_7854());
                if (honeyBottleSlotIndex == -1 || (playerHoneyBottleStack = this.inventory.method_5438(honeyBottleSlotIndex)).method_7960() || ((BuzzingBriefcaseMenu)this.field_2797).player.method_31549().field_7477) continue;
                playerHoneyBottleStack.method_7934(1);
                if (playerHoneyBottleStack.method_7960()) {
                    this.inventory.method_7367(honeyBottleSlotIndex, class_1802.field_8469.method_7854());
                    continue;
                }
                this.inventory.method_7394(class_1802.field_8469.method_7854());
                continue;
            }
            if (mouseX - (double)(mainX + 11) >= 0.0 && mouseX - (double)(mainX + 11) < 11.0 && mouseY - (double)(mainY + 22) >= 0.0 && mouseY - (double)(mainY + 22) < 11.0) {
                class_1799 playerStingerStack;
                if (!bee.method_21785()) continue;
                this.sendButtonPressToMenu(beeIndex * 5 + 2);
                int stingerSlotIndex = this.inventory.method_7395(BzItems.BEE_STINGER.get().method_7854());
                if (stingerSlotIndex == -1 || (playerStingerStack = this.inventory.method_5438(stingerSlotIndex)).method_7960()) continue;
                ((BeeEntityInvoker)bee).callSetHasStung(false);
                if (((BuzzingBriefcaseMenu)this.field_2797).player.method_31549().field_7477) continue;
                playerStingerStack.method_7934(1);
                continue;
            }
            if (mouseX - (double)mainX >= 0.0 && mouseX - (double)mainX < 11.0 && mouseY - (double)(mainY + 33) >= 0.0 && mouseY - (double)(mainY + 33) < 11.0) {
                if (!bee.method_6109()) continue;
                this.sendButtonPressToMenu(beeIndex * 5 + 3);
                honeyBottleSlotIndex = this.inventory.method_7395(class_1802.field_20417.method_7854());
                if (honeyBottleSlotIndex == -1 || (playerHoneyBottleStack = this.inventory.method_5438(honeyBottleSlotIndex)).method_7960() || ((BuzzingBriefcaseMenu)this.field_2797).player.method_31549().field_7477) continue;
                playerHoneyBottleStack.method_7934(1);
                if (playerHoneyBottleStack.method_7960()) {
                    this.inventory.method_7367(honeyBottleSlotIndex, class_1802.field_8469.method_7854());
                    continue;
                }
                this.inventory.method_7394(class_1802.field_8469.method_7854());
                continue;
            }
            if (!(mouseX - (double)(mainX + 11) >= 0.0) || !(mouseX - (double)(mainX + 11) < 11.0) || !(mouseY - (double)(mainY + 33) >= 0.0) || !(mouseY - (double)(mainY + 33) < 11.0) || bee.method_21784() || !bee.method_5864().method_20210(BzTags.BUZZING_BRIEFCASE_CAN_POLLINATE)) continue;
            this.sendButtonPressToMenu(beeIndex * 5 + 4);
            int pollenSlotIndex = this.inventory.method_7395(BzItems.POLLEN_PUFF.get().method_7854());
            if (pollenSlotIndex == -1 || (playerPollenStack = this.inventory.method_5438(pollenSlotIndex)).method_7960() || ((BuzzingBriefcaseMenu)this.field_2797).player.method_31549().field_7477) continue;
            playerPollenStack.method_7934(1);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        return false;
    }

    private void sendButtonPressToMenu(Integer sectionId) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
        this.field_22787.field_1761.method_2900(((BuzzingBriefcaseMenu)this.field_2797).field_7763, sectionId.intValue());
    }

    private int getTrueWidth() {
        return this.field_22789;
    }

    private int getTrueHeight() {
        return this.field_22790 - 29;
    }

    private static int getXOffset(int rowIndex) {
        return -11 + rowIndex * 38;
    }

    private static int getYOffset(int columnIndex) {
        return 46 + columnIndex * 54;
    }

    private record BeeState(class_4466 beeEntity, int primaryColor, int secondaryColor) {
    }
}

