/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.SentryWatcherSpawnEgg;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5575;
import net.minecraft.class_5635;
import net.minecraft.class_5712;
import net.minecraft.class_6862;

public class SentryWatcherEntity
extends class_1297
implements class_1569 {
    private static final class_2940<Boolean> DATA_ID_ACTIVATED = class_2945.method_12791(SentryWatcherEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_ID_SHAKING = class_2945.method_12791(SentryWatcherEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_ID_NO_AI = class_2945.method_12791(SentryWatcherEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2350> DATA_ID_TARGET_FACING = class_2945.method_12791(SentryWatcherEntity.class, (class_2941)class_2943.field_13321);
    private static final class_2940<Optional<UUID>> DATA_ID_OWNER = class_2945.method_12791(SentryWatcherEntity.class, (class_2941)class_2943.field_13313);
    public float xxa;
    public float zza;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    private int shakingTime = 0;
    private class_2350 targetFacing;
    private boolean explosionPrimed = false;
    private boolean quarterTurns = false;
    private boolean prevShaking;
    private int shakeStartTick;
    private class_243 prevVelocity;
    private class_243 activatedStart;
    private int lastRightClicked = -100;
    private static final int MAX_CHARGING_DISTANCE = 80;
    private static final int SIGHT_RANGE = 36;
    private static final int UNABLE_TO_DESTROY_TOTAL_BLOCK_HARDNESS = 20;
    private static final float MAX_STEP_UP = 0.75f;
    private static final float ROTATION_SPEED = 1.5f;
    private static final float ACCELERATION_FLUID = 0.95f;
    private static final float ACCELERATION_GRAVITY = 0.98f;
    private static final float MAX_SPEED_CAP = 2.0f;

    public SentryWatcherEntity(class_1937 worldIn) {
        super(BzEntities.SENTRY_WATCHER.get(), worldIn);
        this.method_49477(0.75f);
        this.field_5985 = true;
    }

    public SentryWatcherEntity(class_1299<? extends SentryWatcherEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_49477(0.75f);
    }

    public int getShakingTime() {
        return this.shakingTime;
    }

    public void setShakingTime(int shakingTime) {
        this.shakingTime = shakingTime;
    }

    public class_2350 getTargetFacing() {
        if (this.targetFacing == null) {
            this.targetFacing = this.method_5735();
        }
        return this.targetFacing;
    }

    public void setTargetFacing(class_2350 targetFacing) {
        this.targetFacing = targetFacing;
        this.setTargetFacingForSync();
    }

    protected void method_5693() {
        this.field_6011.method_12784(DATA_ID_ACTIVATED, (Object)false);
        this.field_6011.method_12784(DATA_ID_SHAKING, (Object)false);
        this.field_6011.method_12784(DATA_ID_NO_AI, (Object)false);
        this.field_6011.method_12784(DATA_ID_TARGET_FACING, (Object)this.getTargetFacing());
        this.field_6011.method_12784(DATA_ID_OWNER, Optional.empty());
    }

    public boolean hasActivated() {
        return (Boolean)this.field_6011.method_12789(DATA_ID_ACTIVATED);
    }

    protected void setHasActivated(boolean activated) {
        this.field_6011.method_12778(DATA_ID_ACTIVATED, (Object)activated);
    }

    public boolean hasShaking() {
        return (Boolean)this.field_6011.method_12789(DATA_ID_SHAKING);
    }

    protected void setHasShaking(boolean isShaking) {
        this.field_6011.method_12778(DATA_ID_SHAKING, (Object)isShaking);
    }

    public boolean hasNoAI() {
        return (Boolean)this.field_6011.method_12789(DATA_ID_NO_AI);
    }

    protected void setNoAI(boolean noAI) {
        this.field_6011.method_12778(DATA_ID_NO_AI, (Object)noAI);
    }

    public class_2350 getTargetFacingFromSync() {
        return (class_2350)this.field_6011.method_12789(DATA_ID_TARGET_FACING);
    }

    public void setTargetFacingForSync() {
        this.field_6011.method_12778(DATA_ID_TARGET_FACING, (Object)this.getTargetFacing());
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.field_6011.method_12789(DATA_ID_OWNER);
    }

    public void setOwner(Optional<UUID> owner) {
        this.field_6011.method_12778(DATA_ID_OWNER, owner);
    }

    public void method_5674(class_2940<?> key) {
        this.method_18382();
        if (this.method_5799() && this.field_5974.method_43048(20) == 0) {
            this.method_5746();
        }
        super.method_5674(key);
    }

    public void method_5652(class_2487 compoundTag) {
        compoundTag.method_10556("explosionPrimed", this.explosionPrimed);
        compoundTag.method_10556("quarterTurns", this.quarterTurns);
        if (this.activatedStart != null) {
            compoundTag.method_10549("activatedStartX", this.activatedStart.method_10216());
            compoundTag.method_10549("activatedStartZ", this.activatedStart.method_10215());
        }
        compoundTag.method_10556("activated", this.hasActivated());
        compoundTag.method_10556("shaking", this.hasShaking());
        compoundTag.method_10569("shakingTime", this.getShakingTime());
        String targetFacingName = this.getTargetFacing().method_10151();
        compoundTag.method_10582("targetFacing", targetFacingName);
        if (compoundTag.method_10545("noAi")) {
            compoundTag.method_10556("noAi", this.hasNoAI());
        } else if (compoundTag.method_10545("noAI")) {
            compoundTag.method_10556("noAI", this.hasNoAI());
        } else {
            compoundTag.method_10556("NoAI", this.hasNoAI());
        }
        if (this.getOwner().isPresent()) {
            compoundTag.method_25927("owner", this.getOwner().get());
        }
    }

    public void method_5749(class_2487 compoundTag) {
        this.explosionPrimed = compoundTag.method_10577("explosionPrimed");
        this.quarterTurns = compoundTag.method_10577("quarterTurns");
        this.activatedStart = new class_243(compoundTag.method_10574("activatedStartX"), 0.0, compoundTag.method_10574("activatedStartZ"));
        this.setHasActivated(compoundTag.method_10577("activated"));
        this.setHasShaking(compoundTag.method_10577("shaking"));
        this.setShakingTime(compoundTag.method_10550("shakingTime"));
        this.setHasShaking(this.getShakingTime() > 0);
        String targetFacingName = compoundTag.method_10558("targetFacing");
        class_2350 targetDirection = class_2350.method_10168((String)targetFacingName);
        this.setTargetFacing(targetDirection);
        this.setNoAI(compoundTag.method_10577("NoAI") || compoundTag.method_10577("noAI") || compoundTag.method_10577("noAi"));
        if (compoundTag.method_10545("owner")) {
            this.setOwner(Optional.of(compoundTag.method_25926("owner")));
        }
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        super.method_5650(removalReason);
        if (this.explosionPrimed && !this.method_37908().method_8608() && removalReason == class_1297.class_5529.field_26998) {
            this.largeExplosion();
        }
    }

    private void largeExplosion() {
        this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 6.0f, class_1937.class_7867.field_40890);
        this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 9.0f, class_1937.class_7867.field_40890);
    }

    public boolean method_7325() {
        return false;
    }

    public boolean method_5863() {
        return true;
    }

    public class_1799 method_31480() {
        return BzItems.SENTRY_WATCHER_SPAWN_EGG.get().method_7854();
    }

    public void method_18382() {
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        super.method_18382();
        this.method_30634(x, y, z);
    }

    public float method_5832(class_2470 rotation) {
        this.setTargetFacing(rotation.method_10503(this.getTargetFacing()));
        float f = class_3532.method_15393((float)this.method_36454());
        return switch (rotation) {
            case class_2470.field_11464 -> f + 180.0f;
            case class_2470.field_11465 -> f + 270.0f;
            case class_2470.field_11463 -> f + 90.0f;
            default -> f;
        };
    }

    public float method_5763(class_2415 mirror) {
        this.setTargetFacing(mirror.method_10343(this.getTargetFacing()));
        float f = class_3532.method_15393((float)this.method_36454());
        return switch (mirror) {
            case class_2415.field_11301 -> -f;
            case class_2415.field_11300 -> 180.0f - f;
            default -> f;
        };
    }

    public Iterable<class_1799> method_5661() {
        return new ArrayList<class_1799>();
    }

    public void method_5673(class_1304 equipmentSlot, class_1799 itemStack) {
    }

    public boolean method_5747(float f, float g, class_1282 arg) {
        if ((double)f > 1.5) {
            this.method_5783(class_3417.field_14928, 1.0f, 0.5f);
            this.playBlockFallSound();
            return true;
        }
        return false;
    }

    protected void playBlockFallSound() {
        if (!this.method_5701()) {
            int i = class_3532.method_15357((double)this.method_23317());
            int j = class_3532.method_15357((double)(this.method_23318() - (double)0.2f));
            int k = class_3532.method_15357((double)this.method_23321());
            class_2338 pos = new class_2338(i, j, k);
            class_2680 blockstate = this.method_37908().method_8320(pos);
            if (!blockstate.method_26215()) {
                class_2498 soundtype = blockstate.method_26231();
                this.method_5783(soundtype.method_10593(), soundtype.method_10597() * 0.5f, soundtype.method_10599() * 0.75f);
            }
        }
    }

    public boolean method_5810() {
        return false;
    }

    public float getFluidSpeed() {
        return 0.95f;
    }

    public boolean method_5692(class_6862<class_3611> tagKey, double d) {
        if (this.method_33724()) {
            return false;
        }
        class_238 aABB = this.method_5829().method_1011(0.001);
        int i = class_3532.method_15357((double)aABB.field_1323);
        int j = class_3532.method_15384((double)aABB.field_1320);
        int k = class_3532.method_15357((double)aABB.field_1322);
        int l = class_3532.method_15384((double)aABB.field_1325);
        int m = class_3532.method_15357((double)aABB.field_1321);
        int n = class_3532.method_15384((double)aABB.field_1324);
        double e = 0.0;
        boolean bl2 = false;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int p = i; p < j; ++p) {
            for (int q = k; q < l; ++q) {
                for (int r = m; r < n; ++r) {
                    double f;
                    mutableBlockPos.method_10103(p, q, r);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutableBlockPos);
                    if (!fluidState.method_15767(tagKey) || !((f = (double)((float)q + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutableBlockPos))) >= aABB.field_1322)) continue;
                    bl2 = true;
                    e = Math.max(f - aABB.field_1322, e);
                }
            }
        }
        this.field_5964.put(tagKey, e);
        return bl2;
    }

    public boolean method_30949(class_1297 entity) {
        RootminEntity rootminEntity;
        if (entity instanceof RootminEntity && (rootminEntity = (RootminEntity)entity).getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
            return false;
        }
        return entity.method_30948() && !this.method_5794(entity);
    }

    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        if (player != null && interactionHand == class_1268.field_5808 && this.getOwner().isPresent() && (this.getOwner().get().equals(player.method_5667()) || this.getOwner().get().equals(SentryWatcherSpawnEgg.DISPENSER_OWNER_UUID))) {
            if (this.field_6012 - this.lastRightClicked < 40) {
                GeneralUtils.givePlayerItem(player, interactionHand, BzItems.SENTRY_WATCHER_SPAWN_EGG.get().method_7854(), false, false);
                this.method_5650(class_1297.class_5529.field_26999);
            } else {
                this.lastRightClicked = this.field_6012;
                this.setHasShaking(true);
                this.setShakingTime(40);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_31481()) {
            this.aiStep();
        }
        if (this.hasActivated() && this.activatedStart != null && Math.abs(this.method_19538().method_37267() - this.activatedStart.method_37267()) > 80.0) {
            this.deactivate();
        }
        this.method_37908().method_16107().method_15396("rangeChecks");
        while (this.method_36454() - this.field_5982 < -180.0f) {
            this.field_5982 -= 360.0f;
        }
        while (this.method_36454() - this.field_5982 >= 180.0f) {
            this.field_5982 += 360.0f;
        }
        while (this.method_36455() - this.field_6004 < -180.0f) {
            this.field_6004 -= 360.0f;
        }
        while (this.method_36455() - this.field_6004 >= 180.0f) {
            this.field_6004 += 360.0f;
        }
        this.method_37908().method_16107().method_15407();
    }

    public void travel() {
        if (this.method_5787()) {
            boolean isFalling;
            double gravityModifier = 0.08;
            boolean bl = isFalling = this.method_18798().field_1351 <= 0.0;
            if (this.method_5799() || this.method_5771()) {
                double e = this.method_23318();
                float speed = this.getFluidSpeed();
                float g = 0.02f;
                float h = 0.0f;
                if (!this.method_24828()) {
                    h *= 0.5f;
                }
                if (h > 0.0f) {
                    speed += (0.54600006f - speed) * h / 3.0f;
                    g += (this.getFluidSpeed() - g) * h / 3.0f;
                }
                this.method_5724(g, class_243.field_1353);
                this.method_5784(class_1313.field_6308, this.method_18798());
                class_243 vec32 = this.method_18798();
                this.method_18799(vec32.method_18805((double)speed, (double)0.8f, (double)speed));
                class_243 vec33 = this.getFluidFallingAdjustedMovement(gravityModifier, isFalling, this.method_18798());
                this.method_18799(vec33);
                if (this.field_5976 && this.method_5654(vec33.field_1352, vec33.field_1351 + (double)0.6f - this.method_23318() + e, vec33.field_1350)) {
                    this.method_18800(vec33.field_1352, 0.3f, vec33.field_1350);
                }
            } else {
                class_2338 blockPos = this.method_23314();
                class_243 vec37 = this.handleRelativeFrictionAndCalculateMovement();
                double ySpeed = vec37.field_1351;
                if (this.method_37908().field_9236 && !this.method_37908().method_22340(blockPos)) {
                    ySpeed = this.method_23318() > (double)this.method_37908().method_31607() ? -0.1 : 0.0;
                } else if (!this.method_5740()) {
                    ySpeed -= gravityModifier;
                }
                this.method_18800(vec37.field_1352, ySpeed * (double)0.98f, vec37.field_1350);
            }
        } else if (this.method_37908().method_8608()) {
            if (this.hasActivated() && this.method_24828() && (Math.abs(this.method_18798().method_10216()) > 0.001 || Math.abs(this.method_18798().method_10215()) > 0.001)) {
                int particlesToSpawn = (int)(1.0 + Math.abs(this.method_18798().method_10216() * 50.0) + Math.abs(this.method_18798().method_10215() + 50.0));
                for (int i = 0; i < particlesToSpawn; ++i) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_19538().method_10216() + this.field_5974.method_43059() * 0.6, this.method_19538().method_10214() + this.field_5974.method_43059() * 0.1 + 0.2, this.method_19538().method_10215() + this.field_5974.method_43059() * 0.6, this.field_5974.method_43059() * 0.01 + 0.01, this.field_5974.method_43059() * 0.01 + 0.01, this.field_5974.method_43059() * 0.01 + 0.01);
                }
            }
            if (this.hasShaking() && (!this.prevShaking || (this.field_6012 - this.shakeStartTick) % 10 == 0)) {
                this.method_37908().method_45446(this.method_24515(), BzSounds.SENTRY_WATCHER_ACTIVATING.get(), class_3419.field_15254, 2.5f, 1.0f, false);
            } else if (this.hasActivated() && !this.hasShaking() && this.field_6012 % 10 == 0) {
                this.method_37908().method_45446(this.method_24515(), BzSounds.SENTRY_WATCHER_MOVING.get(), class_3419.field_15254, 2.0f, 1.0f, false);
            }
            if (!this.prevShaking && this.hasShaking()) {
                this.shakeStartTick = this.field_6012;
            }
            this.prevShaking = this.hasShaking();
        }
        double xSpeed = this.method_18798().method_10216();
        double zSpeed = this.method_18798().method_10215();
        this.method_18800(GeneralUtils.capBetween(xSpeed, -2.0, 2.0), this.method_18798().method_10214(), GeneralUtils.capBetween(zSpeed, -2.0, 2.0));
        this.pushEntities();
    }

    protected void serverAiStep() {
        class_3218 serverLevel;
        class_3449 structureStart;
        class_1937 newX2;
        class_243 offset;
        if (this.getShakingTime() > 0) {
            this.setShakingTime(this.getShakingTime() - 1);
            if (this.getShakingTime() <= 0) {
                this.setHasShaking(false);
            }
        }
        if (this.hasActivated()) {
            if (this.field_5976 && this.method_18798().method_37267() < (double)1.0E-4f) {
                this.deactivate();
                double pastSpeed = this.prevVelocity.method_37267();
                if (pastSpeed > 0.01) {
                    List list = this.method_37908().method_8333((class_1297)this, this.method_5829(), class_1301.method_5911((class_1297)this));
                    for (class_1297 entity : list) {
                        if (entity.method_5864().method_20210(BzTags.SENTRY_WATCHER_CANNOT_DAMAGE)) continue;
                        entity.method_5643(this.method_37908().method_48963().method_48796(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (class_1297)this), 1.0f);
                        if (!(entity instanceof class_1309)) continue;
                        class_1309 livingEntity = (class_1309)entity;
                        float oldHealth = livingEntity.method_6032();
                        float maxhealth = Math.max(livingEntity.method_6032(), livingEntity.method_6063());
                        double healthToLose = class_3532.method_15390((double)(maxhealth / 3.0f), (double)(maxhealth - 1.0f), (double)(pastSpeed - 0.2));
                        double possibleNewHealth = (double)oldHealth - healthToLose;
                        double newHealth = Math.max(possibleNewHealth, 1.0);
                        livingEntity.method_6033((float)newHealth);
                        if (!(livingEntity instanceof class_1657)) continue;
                        class_1657 player = (class_1657)livingEntity;
                        double armorDamage = class_3532.method_15390((double)1.0, (double)8.0, (double)(pastSpeed - 0.2));
                        player.method_31548().method_7375(this.method_37908().method_48963().method_48796(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (class_1297)this), (float)armorDamage, class_1661.field_33767);
                    }
                }
            } else if (!this.hasNoAI() && this.getShakingTime() <= 0) {
                class_243 currentVelocity = this.method_18798();
                double newX2 = currentVelocity.method_10216();
                double newY = currentVelocity.method_10214();
                double newZ = currentVelocity.method_10215();
                class_2350 currentDirection = this.getTargetFacing();
                if (currentDirection.method_10148() != 0) {
                    newX2 += (double)((float)currentDirection.method_10148() / 200.0f);
                    newX2 *= 1.05;
                } else if (currentDirection.method_10165() != 0) {
                    newZ += (double)((float)currentDirection.method_10165() / 200.0f);
                    newZ *= 1.05;
                }
                this.method_18800(newX2, newY, newZ);
            }
        } else if (!this.hasNoAI() && this.field_6012 % 10 == 0 && this.method_36454() == this.getTargetFacing().method_10144() && !this.scanAndBeginActivationIfEnemyFound(offset = class_243.method_24954((class_2382)class_2470.field_11463.method_10503(this.getTargetFacing()).method_10163()).method_1021(0.5))) {
            this.scanAndBeginActivationIfEnemyFound(offset.method_1021(-1.0));
        }
        if (!this.hasNoAI() && this.explosionPrimed && this.field_6012 % 20 == 0 && (newX2 = this.method_37908()) instanceof class_3218 && ((structureStart = (serverLevel = (class_3218)newX2).method_27056().method_41413(this.method_24515(), BzTags.SEMPITERNAL_SANCTUMS)) == null || !structureStart.method_16657())) {
            this.method_5768();
        }
    }

    private boolean scanAndBeginActivationIfEnemyFound(class_243 offset) {
        class_243 eyePosition = this.method_33571().method_1019(offset);
        class_243 finalPos = eyePosition.method_1019(class_243.method_24954((class_2382)this.getTargetFacing().method_10163().method_35862(36)));
        class_238 boundsForChecking = this.method_5829().method_1014(36.0);
        class_3966 entityHitResult = class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)eyePosition, (class_243)finalPos, (class_238)boundsForChecking, this::canSeeEntity);
        if (entityHitResult != null) {
            this.setHasActivated(true);
            this.setShakingTime(40);
            this.setHasShaking(true);
            this.activatedStart = this.method_19538();
            return true;
        }
        finalPos = this.method_19538().method_1031(0.0, 0.1, 0.0).method_1019(class_243.method_24954((class_2382)this.getTargetFacing().method_10163().method_35862(36)));
        boundsForChecking = this.method_5829().method_1014(36.0);
        class_3966 entityHitResult2 = class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)eyePosition, (class_243)finalPos, (class_238)boundsForChecking, this::canSeeEntity);
        if (entityHitResult2 != null) {
            this.setHasActivated(true);
            this.setShakingTime(40);
            this.setHasShaking(true);
            this.activatedStart = this.method_19538();
            return true;
        }
        return false;
    }

    private void deactivate() {
        this.setHasActivated(false);
        if (this.quarterTurns) {
            this.setTargetFacing(this.getTargetFacing().method_10160());
        } else {
            this.setTargetFacing(this.getTargetFacing().method_10153());
        }
        this.method_18800(0.0, this.method_18798().method_10214(), 0.0);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11237, this.method_23317(), this.method_23318() + 0.2, this.method_23321(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.method_14199((class_2394)class_2398.field_29644, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.method_14199((class_2394)class_2398.field_11205, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.method_45445((class_1297)this, this.method_24515(), BzSounds.SENTRY_WATCHER_CRASH.get(), class_3419.field_15254, 2.5f, 1.0f);
        }
    }

    private boolean canSeeEntity(class_1297 entity) {
        class_1657 player;
        if (entity.method_5864().method_20210(BzTags.SENTRY_WATCHER_FORCED_NEVER_ACTIVATES_WHEN_SEEN) || entity.method_7325()) {
            return false;
        }
        if (entity.method_5864().method_20210(BzTags.SENTRY_WATCHER_ACTIVATES_WHEN_SEEN)) {
            return true;
        }
        if (entity instanceof class_1657 && ((player = (class_1657)entity).method_7337() || player.method_5667().equals(this.getOwner().orElse(null)))) {
            return false;
        }
        return entity instanceof class_1309 && !BeeAggression.isBeelikeEntity(entity);
    }

    public void aiStep() {
        if (this.hasNoAI()) {
            return;
        }
        if (this.method_5787()) {
            this.lerpSteps = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.lerpSteps > 0) {
            double d = this.method_23317() + (this.lerpX - this.method_23317()) / (double)this.lerpSteps;
            double e = this.method_23318() + (this.lerpY - this.method_23318()) / (double)this.lerpSteps;
            double f = this.method_23321() + (this.lerpZ - this.method_23321()) / (double)this.lerpSteps;
            double g = class_3532.method_15338((double)(this.lerpYRot - (double)this.method_36454()));
            this.method_36456(this.method_36454() + (float)g / (float)this.lerpSteps);
            this.method_36457(this.method_36455() + (float)(this.lerpXRot - (double)this.method_36455()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.method_5814(d, e, f);
            this.method_5710(this.method_36454(), this.method_36455());
        }
        this.turnToTargetFacing();
        class_243 vec3 = this.method_18798();
        double newX = vec3.field_1352;
        double newY = vec3.field_1351;
        double newZ = vec3.field_1350;
        if (Math.abs(vec3.field_1352) < 0.003) {
            newX = 0.0;
        }
        if (Math.abs(vec3.field_1351) < 0.003) {
            newY = 0.0;
        }
        if (Math.abs(vec3.field_1350) < 0.003) {
            newZ = 0.0;
        }
        this.method_18800(newX, newY, newZ);
        this.method_37908().method_16107().method_15396("ai");
        if (this.isImmobile()) {
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.method_6034()) {
            this.method_37908().method_16107().method_15396("newAi");
            this.serverAiStep();
            this.method_37908().method_16107().method_15407();
        }
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("travel");
        this.travel();
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("freezing");
        if (!this.method_37908().field_9236) {
            int m = this.method_32312();
            if (this.field_27857 && this.method_32316()) {
                this.method_32317(Math.min(this.method_32315(), m + 1));
            } else {
                this.method_32317(Math.max(0, m - 2));
            }
        }
        this.method_37908().method_16107().method_15407();
    }

    private void turnToTargetFacing() {
        if (!this.hasNoAI() && !this.hasActivated() && this.method_36454() != this.getTargetFacingFromSync().method_10144()) {
            double newYDiff;
            double newY;
            double targetY = this.getTargetFacing().method_10144();
            double currentY = this.method_36454();
            double diff = targetY - currentY;
            double diff2 = targetY - (currentY + 360.0);
            double diffToUse = diff;
            if (Math.abs(diff) > Math.abs(diff2)) {
                diffToUse = diff2;
            }
            if ((newY = currentY + (newYDiff = Math.max(Math.min(diffToUse, 1.5), -1.5))) < 0.0) {
                newY += 360.0;
            } else if (newY >= 360.0) {
                newY -= 360.0;
            }
            this.method_36456((float)newY);
            if (this.field_6012 % 20 == 0) {
                this.method_37908().method_45446(this.method_24515(), BzSounds.SENTRY_WATCHER_MOVING.get(), class_3419.field_15254, 0.4f, 0.2f, false);
            }
        }
    }

    protected void pushEntities() {
        if (this.method_37908().method_8608()) {
            this.method_37908().method_18023(class_5575.method_31795(class_1657.class), this.method_5829(), class_1301.method_5911((class_1297)this)).forEach(this::doPush);
        } else {
            List list = this.method_37908().method_8333((class_1297)this, this.method_5829(), class_1301.method_5911((class_1297)this));
            if (!list.isEmpty()) {
                int j;
                int i = this.method_37908().method_8450().method_8356(class_1928.field_19405);
                if (i > 0 && list.size() > i - 1 && this.field_5974.method_43048(4) == 0) {
                    j = 0;
                    for (class_1297 entity : list) {
                        if (entity.method_5765()) continue;
                        ++j;
                    }
                }
                for (j = 0; j < list.size(); ++j) {
                    class_1297 entity = (class_1297)list.get(j);
                    this.doPush(entity);
                }
            }
        }
    }

    protected void doPush(class_1297 entity) {
        if (entity instanceof class_1309) {
            double speedDiff;
            class_243 currentVelocity = this.method_18798();
            class_243 victimVelocity = entity.method_18798();
            class_243 diffVelocity = currentVelocity.method_1020(victimVelocity);
            double d = speedDiff = this.getTargetFacing().method_10148() != 0 ? Math.abs(diffVelocity.method_10216()) : Math.abs(diffVelocity.method_10215());
            if (speedDiff > 0.2) {
                speedDiff -= 0.1;
                double pushEffect = 1.1;
                entity.method_18800(0.0, entity.method_18798().method_10214(), 0.0);
                entity.method_5762(this.method_18798().method_10216() * pushEffect, 0.0, this.method_18798().method_10215() * pushEffect);
                class_238 sentryBounds = this.method_5829();
                class_243 pushToSpot = entity.method_19538();
                switch (this.getTargetFacing()) {
                    case field_11043: {
                        pushToSpot = new class_243(pushToSpot.method_10216(), pushToSpot.method_10214(), sentryBounds.field_1321);
                        break;
                    }
                    case field_11035: {
                        pushToSpot = new class_243(pushToSpot.method_10216(), pushToSpot.method_10214(), sentryBounds.field_1324);
                        break;
                    }
                    case field_11039: {
                        pushToSpot = new class_243(sentryBounds.field_1323, pushToSpot.method_10214(), pushToSpot.method_10215());
                        break;
                    }
                    case field_11034: {
                        pushToSpot = new class_243(sentryBounds.field_1320, pushToSpot.method_10214(), pushToSpot.method_10215());
                    }
                }
                entity.method_33574(pushToSpot);
                if (!this.method_37908().method_8608() && !entity.method_5864().method_20210(BzTags.SENTRY_WATCHER_CANNOT_DAMAGE)) {
                    class_3222 serverPlayer;
                    float damageMultiplier = 30.0f;
                    if (entity instanceof class_3222 && EssenceOfTheBees.hasEssence(serverPlayer = (class_3222)entity)) {
                        damageMultiplier = 16.0f;
                    }
                    int beeArmorOn = BeeArmor.getBeeThemedWearablesCount(entity);
                    entity.method_5643(this.method_37908().method_48963().method_48796(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (class_1297)this), (float)(speedDiff * (double)(damageMultiplier -= (float)beeArmorOn * 1.333333f)));
                }
            } else {
                super.method_5697(entity);
            }
        } else if (entity instanceof SentryWatcherEntity) {
            this.deactivate();
        } else {
            super.method_5697(entity);
        }
    }

    public void method_5762(double d, double e, double f) {
    }

    public class_243 handleRelativeFrictionAndCalculateMovement() {
        class_243 deltaMovement = this.method_18798();
        if (!this.hasActivated()) {
            deltaMovement = deltaMovement.method_18805(0.9, 1.0, 0.9);
        }
        this.method_5784(class_1313.field_6308, deltaMovement);
        deltaMovement = this.method_18798();
        if (this.field_5976 && this.method_36601().method_27852(class_2246.field_27879) && class_5635.method_32355((class_1297)this)) {
            deltaMovement = new class_243(deltaMovement.field_1352, 0.2, deltaMovement.field_1350);
        }
        return deltaMovement;
    }

    public class_243 getFluidFallingAdjustedMovement(double d, boolean bl, class_243 vec3) {
        if (!this.method_5740() && !this.method_5624()) {
            double e = bl && Math.abs(vec3.field_1351 - 0.005) >= 0.003 && Math.abs(vec3.field_1351 - d / 16.0) < 0.003 ? -0.003 : vec3.field_1351 - d / 16.0;
            return new class_243(vec3.field_1352, e, vec3.field_1350);
        }
        return vec3;
    }

    public void method_5784(class_1313 moverType, class_243 vec3) {
        if (this.field_5960) {
            this.method_5814(this.method_23317() + vec3.field_1352, this.method_23318() + vec3.field_1351, this.method_23321() + vec3.field_1350);
        } else {
            class_243 collision;
            double d;
            this.field_28629 = this.method_5809();
            if (moverType == class_1313.field_6310 && (vec3 = this.method_18794(vec3)).equals((Object)class_243.field_1353)) {
                return;
            }
            this.method_37908().method_16107().method_15396("move");
            if (this.field_17046.method_1027() > 1.0E-7) {
                vec3 = vec3.method_18806(this.field_17046);
                this.field_17046 = class_243.field_1353;
                this.method_18799(class_243.field_1353);
            }
            if ((d = (collision = this.collide(vec3 = this.method_18796(vec3, moverType))).method_1027()) > 1.0E-7) {
                class_3965 blockHitResult;
                if (this.field_6017 != 0.0f && d >= 1.0 && (blockHitResult = this.method_37908().method_17742(new class_3959(this.method_19538(), this.method_19538().method_1019(collision), class_3959.class_3960.field_36337, class_3959.class_242.field_36338, (class_1297)this))).method_17783() != class_239.class_240.field_1333) {
                    this.method_38785();
                }
                this.method_5814(this.method_23317() + collision.field_1352, this.method_23318() + collision.field_1351, this.method_23321() + collision.field_1350);
            }
            this.method_37908().method_16107().method_15407();
            this.method_37908().method_16107().method_15396("rest");
            this.prevVelocity = vec3;
            boolean loseXSpeed = !class_3532.method_20390((double)vec3.field_1352, (double)collision.field_1352);
            boolean loseZSpeed = !class_3532.method_20390((double)vec3.field_1350, (double)collision.field_1350);
            this.field_5976 = loseXSpeed || loseZSpeed;
            this.field_5992 = vec3.field_1351 != collision.field_1351;
            this.field_36331 = this.field_5992 && vec3.field_1351 < 0.0;
            class_243 deltaMovement = this.method_18798();
            if (this.field_5976 && Math.abs(deltaMovement.method_10216()) + Math.abs(deltaMovement.method_10215()) > 0.01) {
                this.destroyBlocksInWay();
            }
            this.field_34927 = this.field_5976 ? this.method_39759(collision) : false;
            this.method_52208(this.field_36331, collision);
            class_2338 blockPos = this.method_43260();
            class_2680 blockState = this.method_37908().method_8320(blockPos);
            this.method_5623(collision.field_1351, this.method_24828(), blockState, blockPos);
            if (this.method_31481()) {
                this.method_37908().method_16107().method_15407();
            } else {
                class_1297.class_5799 movementEmission;
                if (this.field_5976) {
                    class_243 vec33 = this.method_18798();
                    this.method_18800(loseXSpeed ? 0.0 : vec33.field_1352, vec33.field_1351, loseZSpeed ? 0.0 : vec33.field_1350);
                }
                class_2248 block = blockState.method_26204();
                if (vec3.field_1351 != collision.field_1351) {
                    block.method_9502((class_1922)this.method_37908(), (class_1297)this);
                }
                if (this.method_24828()) {
                    block.method_9591(this.method_37908(), blockPos, blockState, (class_1297)this);
                }
                if ((movementEmission = this.method_33570()).method_33576() && !this.method_5765()) {
                    double e = collision.field_1352;
                    double f = collision.field_1351;
                    double g = collision.field_1350;
                    this.field_28627 += (float)(collision.method_1033() * 0.6);
                    class_2338 blockPos2 = this.method_23312();
                    class_2680 blockState2 = this.method_37908().method_8320(blockPos2);
                    this.field_5973 += (float)collision.method_37267() * 0.6f;
                    this.field_5994 += (float)Math.sqrt(e * e + f * f + g * g) * 0.6f;
                    if (this.field_5994 > ((EntityAccessor)((Object)this)).getNextStep() && !blockState2.method_26215()) {
                        boolean bl4 = blockPos2.equals((Object)blockPos);
                        boolean bl5 = ((EntityAccessor)((Object)this)).callVibrationAndSoundEffectsFromBlock(blockPos, blockState, movementEmission.method_33578(), bl4, vec3);
                        if (!bl4) {
                            bl5 |= ((EntityAccessor)((Object)this)).callVibrationAndSoundEffectsFromBlock(blockPos2, blockState2, false, movementEmission.method_33577(), vec3);
                        }
                        if (bl5) {
                            ((EntityAccessor)((Object)this)).setNextStep(this.method_5867());
                        } else if (this.method_5799()) {
                            ((EntityAccessor)((Object)this)).setNextStep(this.method_5867());
                            if (movementEmission.method_33578()) {
                                this.method_51295();
                            }
                            if (movementEmission.method_33577()) {
                                this.method_32876(class_5712.field_28156);
                            }
                        }
                    } else if (blockState2.method_26215()) {
                        this.method_33573();
                    }
                }
                this.method_36974();
                if (this.method_37908().method_29556(this.method_5829().method_1011(1.0E-6)).noneMatch(blockStatex -> blockStatex.method_26164(class_3481.field_21952) || blockStatex.method_27852(class_2246.field_10164))) {
                    if (this.method_20802() <= 0) {
                        this.method_20803(-this.method_5676());
                    }
                    if (this.field_28629 && (this.field_27857 || this.method_5637())) {
                        this.method_36975();
                    }
                }
                if (this.method_5809() && (this.field_27857 || this.method_5637())) {
                    this.method_20803(-this.method_5676());
                }
                this.method_37908().method_16107().method_15407();
            }
        }
    }

    private void destroyBlocksInWay() {
        class_2350 facing = this.getTargetFacing();
        class_238 aabb = this.method_5829();
        class_2338 min = null;
        class_2338 max = null;
        double xStep = (double)facing.method_10148() / 3.0;
        double zStep = (double)facing.method_10165() / 3.0;
        switch (facing) {
            case field_11043: {
                min = new class_2338((int)Math.floor(aabb.field_1323 + xStep + 1.0E-4), (int)Math.floor(aabb.field_1322), (int)Math.floor(aabb.field_1321 + zStep + 1.0E-4));
                max = new class_2338((int)Math.floor(aabb.field_1320 + xStep - (double)1.0E-4f), (int)Math.floor(aabb.field_1322), (int)Math.floor(aabb.field_1321 + zStep + 1.0E-4));
                break;
            }
            case field_11035: {
                min = new class_2338((int)Math.floor(aabb.field_1323 + xStep + 1.0E-4), (int)Math.floor(aabb.field_1322), (int)Math.floor(aabb.field_1324 + zStep - 1.0E-4));
                max = new class_2338((int)Math.floor(aabb.field_1320 + xStep - 1.0E-4), (int)Math.floor(aabb.field_1322), (int)Math.floor(aabb.field_1324 + zStep - 1.0E-4));
                break;
            }
            case field_11039: {
                min = new class_2338((int)Math.floor(aabb.field_1323 + xStep + 1.0E-4), (int)Math.floor(aabb.field_1322), (int)Math.floor(aabb.field_1321 + zStep + 1.0E-4));
                max = new class_2338((int)Math.floor(aabb.field_1323 + xStep + 1.0E-4), (int)Math.floor(aabb.field_1322), (int)Math.floor(aabb.field_1324 + zStep - 1.0E-4));
                break;
            }
            case field_11034: {
                min = new class_2338((int)Math.floor(aabb.field_1320 + xStep - 1.0E-4), (int)Math.floor(aabb.field_1322), (int)Math.floor(aabb.field_1321 + zStep + 1.0E-4));
                max = new class_2338((int)Math.floor(aabb.field_1320 + xStep - 1.0E-4), (int)Math.floor(aabb.field_1322), (int)Math.floor(aabb.field_1324 + zStep - 1.0E-4));
            }
        }
        if (min != null && this.getOwner().isEmpty()) {
            boolean canDemolish = true;
            double totalhardness = 0.0;
            int alwaysDestroyCounter = 0;
            ArrayList<class_2338> demolishPos = new ArrayList<class_2338>();
            for (class_2338 pos : class_2338.method_10097(min, max)) {
                class_2680 state = this.method_37908().method_8320(pos);
                class_265 blockShape = state.method_26220((class_1922)this.method_37908(), pos);
                if ((!blockShape.method_1110() || state.method_26164(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) && blockShape.method_1105(class_2350.class_2351.field_11052) > this.method_23318() - (double)this.method_31478()) {
                    if (state.method_26164(BzTags.SENTRY_WATCHER_FORCED_NEVER_DESTROY)) {
                        canDemolish = false;
                        break;
                    }
                    demolishPos.add(pos.method_10062());
                    totalhardness += (double)state.method_26204().method_9520();
                    if (state.method_26164(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) {
                        ++alwaysDestroyCounter;
                    }
                }
                class_2338 abovePos = pos.method_10084();
                class_2680 aboveState = this.method_37908().method_8320(abovePos);
                if (aboveState.method_26220((class_1922)this.method_37908(), abovePos).method_1110() && !aboveState.method_26164(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) continue;
                if (aboveState.method_26164(BzTags.SENTRY_WATCHER_FORCED_NEVER_DESTROY)) {
                    canDemolish = false;
                    break;
                }
                demolishPos.add(abovePos);
                totalhardness += (double)aboveState.method_26204().method_9520();
                if (!aboveState.method_26164(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) continue;
                ++alwaysDestroyCounter;
            }
            if (canDemolish && (alwaysDestroyCounter == demolishPos.size() || totalhardness < 20.0)) {
                for (class_2338 pos : demolishPos) {
                    this.method_37908().method_22352(pos, true);
                }
                this.field_5976 = false;
            }
        }
    }

    private class_243 collide(class_243 incomingSpeed) {
        boolean zCollided;
        class_238 sentryBoundingBox = this.method_5829();
        ArrayList shapesCollidedWith = new ArrayList();
        boolean isNotMoving = incomingSpeed.method_1027() == 0.0;
        class_243 collidedVelocity = isNotMoving ? incomingSpeed : SentryWatcherEntity.method_20736((class_1297)this, (class_243)incomingSpeed, (class_238)sentryBoundingBox, (class_1937)this.method_37908(), shapesCollidedWith);
        boolean xCollided = incomingSpeed.field_1352 != collidedVelocity.field_1352;
        boolean bl = zCollided = incomingSpeed.field_1350 != collidedVelocity.field_1350;
        if (this.method_49476() > 0.0f && (xCollided || zCollided)) {
            class_243 vec35;
            class_243 vec33 = SentryWatcherEntity.method_20736((class_1297)this, (class_243)new class_243(incomingSpeed.field_1352, (double)this.method_49476(), incomingSpeed.field_1350), (class_238)sentryBoundingBox, (class_1937)this.method_37908(), shapesCollidedWith);
            class_243 vec34 = SentryWatcherEntity.method_20736((class_1297)this, (class_243)new class_243(0.0, (double)this.method_49476(), 0.0), (class_238)sentryBoundingBox.method_1012(incomingSpeed.field_1352, 0.0, incomingSpeed.field_1350), (class_1937)this.method_37908(), shapesCollidedWith);
            if (vec34.field_1351 < (double)this.method_49476() && (vec35 = SentryWatcherEntity.method_20736((class_1297)this, (class_243)new class_243(incomingSpeed.field_1352, 0.0, incomingSpeed.field_1350), (class_238)sentryBoundingBox.method_997(vec34), (class_1937)this.method_37908(), shapesCollidedWith).method_1019(vec34)).method_37268() > vec33.method_37268()) {
                vec33 = vec35;
            }
            if (vec33.method_37268() > collidedVelocity.method_37268()) {
                return vec33.method_1019(SentryWatcherEntity.method_20736((class_1297)this, (class_243)new class_243(0.0, -vec33.field_1351 + incomingSpeed.field_1351, 0.0), (class_238)sentryBoundingBox.method_997(vec33), (class_1937)this.method_37908(), shapesCollidedWith));
            }
        }
        return collidedVelocity;
    }

    public void method_5759(double d, double e, double f, float g, float h, int i) {
        this.lerpX = d;
        this.lerpY = e;
        this.lerpZ = f;
        this.lerpYRot = g;
        this.lerpXRot = h;
        this.lerpSteps = i;
    }

    public double method_53830() {
        return this.lerpSteps > 0 ? this.lerpX : this.method_23317();
    }

    public double method_53827() {
        return this.lerpSteps > 0 ? this.lerpY : this.method_23318();
    }

    public double method_53828() {
        return this.lerpSteps > 0 ? this.lerpZ : this.method_23321();
    }

    public float method_53829() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.method_36455();
    }

    public float method_53831() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.method_36454();
    }

    public boolean method_5822() {
        return false;
    }

    public float method_43078() {
        return this.method_36454();
    }

    protected boolean isImmobile() {
        return false;
    }
}

