/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5354;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class RagingEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.ragingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.ragingEssenceAbilityUse;
    private static final int radius = 24;
    private static final int trackingRange = 2304;
    private static final int maxEmpoweredTimeFramePer5Ticks = 75;
    private static final int maxCurrentTargets = 4;
    private static final String RAGE_STATE_TAG = "rageStateLevel";
    private static final String CURRENT_TARGET_TAG = "currentTargets";
    private static final String EMPOWERED_TIME_REMAINING_TAG = "empoweredTimeRemaining";

    public RagingEssence(class_1792.class_1793 properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 0xFF2B2B;
    }

    @Override
    void addDescriptionComponents(List<class_2561> components) {
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_raging_description_1").method_27692(class_124.field_1061).method_27692(class_124.field_1056));
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_raging_description_2").method_27692(class_124.field_1061).method_27692(class_124.field_1056));
    }

    public static void setRageState(class_1799 stack, short rageState) {
        stack.method_7948().method_10575(RAGE_STATE_TAG, rageState);
    }

    public static short getRageState(class_1799 stack) {
        return stack.method_7948().method_10568(RAGE_STATE_TAG);
    }

    public static void setEmpoweredTimeRemaining(class_1799 stack, int empoweredTimeRemaining) {
        stack.method_7948().method_10569(EMPOWERED_TIME_REMAINING_TAG, empoweredTimeRemaining);
    }

    public static int getEmpoweredTimeRemaining(class_1799 stack) {
        return stack.method_7948().method_10550(EMPOWERED_TIME_REMAINING_TAG);
    }

    public static void setCurrentTargets(class_1799 stack, List<UUID> targetsToKill) {
        class_2487 compoundTag = stack.method_7948();
        class_2499 targetList = new class_2499();
        for (UUID target : targetsToKill) {
            targetList.add((Object)class_2512.method_25929((UUID)target));
        }
        compoundTag.method_10566(CURRENT_TARGET_TAG, (class_2520)targetList);
    }

    public static List<UUID> getCurrentTargets(class_1799 stack) {
        class_2487 compoundTag = stack.method_7948();
        class_2499 targetListTags = compoundTag.method_10554(CURRENT_TARGET_TAG, 11);
        ArrayList<UUID> targetsToKill = new ArrayList<UUID>();
        for (class_2520 tag : targetListTags) {
            targetsToKill.add(class_2512.method_25930((class_2520)tag));
        }
        return targetsToKill;
    }

    public void decrementAbilityUseRemaining(class_1799 stack, class_3222 serverPlayer, int decreaseAmount) {
        int getRemainingUse = Math.max(this.getAbilityUseRemaining(stack) - decreaseAmount, 0);
        this.setAbilityUseRemaining(stack, getRemainingUse);
        if (getRemainingUse == 0) {
            this.setDepleted(stack, serverPlayer, false);
        }
    }

    @Override
    public void applyAbilityEffects(class_1799 stack, class_1937 level, class_3222 serverPlayer) {
        if (RagingEssence.getIsActive(stack) && BzGeneralConfigs.ragingEssenceStrengthLevels.length > 0) {
            short rageState = RagingEssence.getRageState(stack);
            if (rageState > BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                RagingEssence.setRageState(stack, (short)BzGeneralConfigs.ragingEssenceStrengthLevels.length);
                rageState = (short)BzGeneralConfigs.ragingEssenceStrengthLevels.length;
            }
            if (rageState > 0 && ((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 5L == 0L) {
                RagingEssence.spawnParticles(serverPlayer.method_51469(), serverPlayer.method_19538(), serverPlayer.method_6051(), rageState);
                int empoweredTimeRemaining = RagingEssence.getEmpoweredTimeRemaining(stack) - 1;
                RagingEssence.setEmpoweredTimeRemaining(stack, empoweredTimeRemaining);
                if (empoweredTimeRemaining == 0) {
                    RagingEssence.resetRage(stack, serverPlayer);
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                    if (RagingEssence.getForcedCooldown(stack)) {
                        return;
                    }
                }
            }
            if (((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 20L == 0L) {
                Object entities;
                List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(stack);
                if (currentTargetsToKill.size() < 4 && rageState + currentTargetsToKill.size() <= BzGeneralConfigs.ragingEssenceStrengthLevels.length && !(entities = level.method_8333((class_1297)serverPlayer, new class_238(serverPlayer.method_23317() - 24.0, serverPlayer.method_23318() - 6.0, serverPlayer.method_23321() - 24.0, serverPlayer.method_23317() + 24.0, serverPlayer.method_23318() + 6.0, serverPlayer.method_23321() + 24.0), e -> !currentTargetsToKill.contains(e.method_5667()) && RagingEssence.isTargetable(e, serverPlayer.method_5667()))).isEmpty() && currentTargetsToKill.size() < 4) {
                    int entitiesToAdd;
                    entities.sort((e1, e2) -> (int)(((class_1309)e1).method_6032() - ((class_1309)e2).method_6032()));
                    int rageLeft = BzGeneralConfigs.ragingEssenceStrengthLevels.length - rageState;
                    for (int i = entitiesToAdd = Math.min(rageLeft + 1, 4) - currentTargetsToKill.size(); i >= 1 && !entities.isEmpty(); --i) {
                        if (i == 1) {
                            currentTargetsToKill.add(((class_1297)entities.remove(entities.size() - 1)).method_5667());
                            continue;
                        }
                        currentTargetsToKill.add(((class_1297)entities.remove(0)).method_5667());
                    }
                    RagingEssence.setCurrentTargets(stack, currentTargetsToKill);
                    return;
                }
                if (!currentTargetsToKill.isEmpty()) {
                    for (UUID uuid : currentTargetsToKill) {
                        class_1297 entity = serverPlayer.method_51469().method_14190(uuid);
                        if (entity != null && !(entity.method_5707(serverPlayer.method_19538()) > 5308416.0)) continue;
                        RagingEssence.resetRage(stack, serverPlayer);
                        return;
                    }
                }
                if (rageState > 0) {
                    List<class_6880> radianceEffects = class_7923.field_41174.method_40266(BzTags.RAGING_RAGE_EFFECTS).stream().flatMap(class_6885.class_6887::method_40239).filter(class_6880::method_40227).toList();
                    for (class_6880 effectHolder : radianceEffects) {
                        if (effectHolder.comp_349() == class_1294.field_5910) {
                            serverPlayer.method_6092(new class_1293(class_1294.field_5910, RagingEssence.getEmpoweredTimeRemaining(stack) * 4, BzGeneralConfigs.ragingEssenceStrengthLevels[rageState - 1] - 1, false, false));
                            continue;
                        }
                        serverPlayer.method_6092(new class_1293((class_1291)effectHolder.comp_349(), RagingEssence.getEmpoweredTimeRemaining(stack) * 4, (int)rageState, false, false));
                    }
                }
            }
        }
    }

    public static void OnEntityDeath(EntityDeathEvent event) {
        class_1282 damageSource = event.source();
        class_1309 livingEntity = event.entity();
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_3222) {
            class_1792 class_17922;
            class_3222 player = (class_3222)class_12972;
            class_1799 stack = player.method_6079();
            if (livingEntity.method_29504() && (class_17922 = stack.method_7909()) instanceof RagingEssence) {
                RagingEssence ragingEssence = (RagingEssence)class_17922;
                if (RagingEssence.getIsActive(stack) && !player.method_7357().method_7904(stack.method_7909())) {
                    List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(stack);
                    short rageState = RagingEssence.getRageState(stack);
                    if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length || currentTargetsToKill.contains(livingEntity.method_5667())) {
                        if (rageState >= BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                            RagingEssence.resetRage(stack, player);
                        } else {
                            RagingEssence.setRageState(stack, (short)(rageState + 1));
                            RagingEssence.setEmpoweredTimeRemaining(stack, 75);
                            currentTargetsToKill.remove(livingEntity.method_5667());
                            RagingEssence.setCurrentTargets(stack, currentTargetsToKill);
                            ragingEssence.decrementAbilityUseRemaining(stack, player, 1);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTargetable(class_1297 entity, UUID playerUUID) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (entity.method_5655()) return false;
        if (!livingEntity.method_6102()) return false;
        if (livingEntity.method_29504()) return false;
        if (entity instanceof class_1569) return true;
        if (!(entity instanceof class_5354)) return false;
        class_5354 neutralMob = (class_5354)entity;
        if (neutralMob.method_29508() != playerUUID) return false;
        return true;
    }

    private static void resetRage(class_1799 stack, class_3222 serverPlayer) {
        RagingEssence.setCurrentTargets(stack, new ArrayList<UUID>());
        RagingEssence.setRageState(stack, (short)0);
        List<class_6880> radianceEffects = class_7923.field_41174.method_40266(BzTags.RAGING_RAGE_EFFECTS).stream().flatMap(class_6885.class_6887::method_40239).filter(class_6880::method_40227).toList();
        for (class_6880 effectHolder : radianceEffects) {
            serverPlayer.method_6016((class_1291)effectHolder.comp_349());
        }
        serverPlayer.method_51469().method_14199((class_2394)class_2398.field_11203, serverPlayer.method_19538().method_10216(), serverPlayer.method_19538().method_10214() + 1.0, serverPlayer.method_19538().method_10215(), 50, serverPlayer.method_6051().method_43059() * 0.3, serverPlayer.method_6051().method_43059() * 0.25 + 0.1, serverPlayer.method_6051().method_43059() * 0.3, (double)0.06f);
    }

    public static void spawnParticles(class_3218 world, class_243 location, class_5819 random, int rageState) {
        if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
            rageState *= 2;
        }
        world.method_14199((class_2394)class_2398.field_11240, location.method_10216(), location.method_10214() + 1.0, location.method_10215(), rageState, random.method_43059() * 0.2, random.method_43059() * 0.25 + 0.1, random.method_43059() * 0.2, (double)0.02f);
        world.method_14199((class_2394)class_2398.field_11205, location.method_10216(), location.method_10214() + 1.0, location.method_10215(), rageState, random.method_43059() * 0.2, random.method_43059() * 0.25 + 0.1, random.method_43059() * 0.2, (double)0.1f);
    }

    public static boolean IsRagingEssenceActive(class_1657 player) {
        if (player != null) {
            class_1799 offHandItem = player.method_6079();
            return offHandItem.method_31574(BzItems.ESSENCE_RAGING.get()) && RagingEssence.getIsActive(offHandItem) && !player.method_7357().method_7904(offHandItem.method_7909());
        }
        return false;
    }

    public static boolean IsValidEntityToGlow(class_1297 entity, class_1657 player) {
        return RagingEssence.GetTeamColor(entity, player) != -1;
    }

    public static int GetTeamColor(class_1297 entity, class_1657 player) {
        class_1799 stack = player.method_6079();
        short rageState = RagingEssence.getRageState(stack);
        List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(stack);
        if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length && RagingEssence.isTargetable(entity, player.method_5667()) || currentTargetsToKill.contains(entity.method_5667())) {
            if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                float percentage = Math.abs((float)(player.field_6012 % 40 - 20) / 20.0f);
                int red = 255;
                int green = class_3532.method_48781((float)percentage, (int)0, (int)128);
                return (red & 0xFF) << 16 | (green & 0xFF) << 8;
            }
            float percentage = (float)rageState / (float)BzGeneralConfigs.ragingEssenceStrengthLevels.length;
            return class_3532.method_48781((float)percentage, (int)85, (int)255) << 16;
        }
        return -1;
    }
}

