/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.Map;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class ContainerCraftingRecipe
implements class_3955 {
    private final String group;
    private final class_7710 category;
    private final class_1799 result;
    private final class_2371<class_1856> ingredients;
    public static final Map<class_1792, class_1792> HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET = Map.ofEntries(Map.entry(class_1802.field_27876, class_1802.field_8550), Map.entry(class_1802.field_28354, class_1802.field_8550), Map.entry(class_1802.field_8666, class_1802.field_8550), Map.entry(class_1802.field_8108, class_1802.field_8550), Map.entry(class_1802.field_8714, class_1802.field_8550), Map.entry(class_1802.field_8478, class_1802.field_8550), Map.entry(class_1802.field_8766, class_1802.field_8428), Map.entry(class_1802.field_8208, class_1802.field_8428), Map.entry(class_1802.field_8308, class_1802.field_8428), Map.entry(class_1802.field_8515, class_1802.field_8428), Map.entry(class_1802.field_8574, class_1802.field_8469), Map.entry(class_1802.field_8436, class_1802.field_8469), Map.entry(class_1802.field_8150, class_1802.field_8469), Map.entry(class_1802.field_8287, class_1802.field_8469));

    public ContainerCraftingRecipe(String groupIn, class_7710 craftingBookCategory, class_1799 recipeOutputIn, class_2371<class_1856> recipeItemsIn) {
        this.group = groupIn;
        this.category = craftingBookCategory;
        this.result = recipeOutputIn;
        this.ingredients = recipeItemsIn;
    }

    public class_1865<?> method_8119() {
        return BzRecipes.CONTAINER_CRAFTING_RECIPE.get();
    }

    public String method_8112() {
        return this.group;
    }

    public class_7710 method_45441() {
        return this.category;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public boolean matches(class_8566 craftingContainer, class_1937 level) {
        class_1662 stackedContents = new class_1662();
        int i = 0;
        for (int j = 0; j < craftingContainer.method_5439(); ++j) {
            class_1799 itemStack = craftingContainer.method_5438(j);
            if (itemStack.method_7960()) continue;
            ++i;
            stackedContents.method_20478(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.method_7402((class_1860)this, null);
    }

    public class_1799 assemble(class_8566 craftingContainer, class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public boolean method_8113(int i, int j) {
        return i * j >= this.ingredients.size();
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inv) {
        class_2371 remainingInv = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
        int containerOutput = PlatformHooks.hasCraftingRemainder(this.result) ? this.result.method_7947() : 0;
        for (int i = 0; i < remainingInv.size(); ++i) {
            class_1799 craftingInput = inv.method_5438(i);
            class_1799 craftingContainer = PlatformHooks.getCraftingRemainder(craftingInput);
            class_1799 recipeContainer = PlatformHooks.getCraftingRemainder(this.result);
            if (craftingContainer.method_7960() && HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.containsKey(craftingInput.method_7909())) {
                craftingContainer = HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.get(craftingInput.method_7909()).method_7854();
            }
            if (recipeContainer.method_7960() && HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.containsKey(this.result.method_7909())) {
                recipeContainer = HARDCODED_EDGECASES_WITHOUT_CONTAINERS_SET.get(this.result.method_7909()).method_7854();
            }
            if (craftingContainer.method_7960()) continue;
            if (containerOutput > 0 && (this.result.method_7909() == craftingContainer.method_7909() || recipeContainer.method_7909() == craftingInput.method_7909() || recipeContainer.method_7909() == craftingContainer.method_7909())) {
                --containerOutput;
                continue;
            }
            remainingInv.set(i, (Object)craftingContainer);
        }
        return remainingInv;
    }

    public static class Serializer
    implements class_1865<ContainerCraftingRecipe> {
        private static final Codec<ContainerCraftingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53049((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(shapelessRecipe -> shapelessRecipe.group), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(shapelessRecipe -> shapelessRecipe.category), (App)class_1799.field_47309.fieldOf("result").forGetter(shapelessRecipe -> shapelessRecipe.result), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (class_1856[])list.toArray(class_1856[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
        }, DataResult::success).forGetter(shapelessRecipe -> shapelessRecipe.ingredients)).apply((Applicative)instance, ContainerCraftingRecipe::new));

        public Codec<ContainerCraftingRecipe> method_53736() {
            return CODEC;
        }

        public ContainerCraftingRecipe fromNetwork(class_2540 buffer) {
            String s = buffer.method_10800(Short.MAX_VALUE);
            class_7710 craftingBookCategory = (class_7710)buffer.method_10818(class_7710.class);
            int i = buffer.method_10816();
            class_2371 defaultedList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < defaultedList.size(); ++j) {
                defaultedList.set(j, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 itemstack = buffer.method_10819();
            return new ContainerCraftingRecipe(s, craftingBookCategory, itemstack, (class_2371<class_1856>)defaultedList);
        }

        public void toNetwork(class_2540 buffer, ContainerCraftingRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10817((Enum)recipe.method_45441());
            buffer.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.result);
        }
    }
}

