/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.fabric;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import net.minecraft.class_2350;
import net.minecraft.class_4588;
import org.joml.Vector3fc;

public class SodiumSinkingVertexBuilder
implements class_4588 {
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(0x200000).order(ByteOrder.nativeOrder());
    private final int[] sideCount = new int[ModelQuadFacing.VALUES.length];
    private int currentVertex;
    private float x;
    private float y;
    private float z;
    private float nx;
    private float ny;
    private float nz;
    private float u;
    private float v;
    private int color;
    private int light;
    private int fixedColor;
    private boolean hasFixedColor = false;
    private static final ThreadLocal<SodiumSinkingVertexBuilder> instance = ThreadLocal.withInitial(SodiumSinkingVertexBuilder::new);
    private final ChunkVertexEncoder.Vertex[] sodiumVertexArray = ChunkVertexEncoder.Vertex.uninitializedQuad();

    public static SodiumSinkingVertexBuilder getInstance() {
        return instance.get();
    }

    public class_4588 method_22912(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        return this;
    }

    public class_4588 method_1336(int r, int g, int b, int a) {
        this.color = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        return this;
    }

    public void method_22901(int r, int g, int b, int a) {
        this.fixedColor = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        this.hasFixedColor = true;
    }

    public void method_35666() {
        this.hasFixedColor = false;
    }

    public class_4588 method_22913(float u, float v) {
        this.u = u;
        this.v = v;
        return this;
    }

    public class_4588 method_22917(int u, int v) {
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        this.light = v << 16 | u;
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        this.nx = x;
        this.ny = y;
        this.nz = z;
        return this;
    }

    public void method_1344() {
        class_2350 dir = class_2350.method_50026((int)((int)this.nx), (int)((int)this.ny), (int)((int)this.nz));
        int normal = dir != null ? dir.ordinal() : -1;
        this.buffer.putInt(normal);
        this.buffer.putFloat(this.x);
        this.buffer.putFloat(this.y);
        this.buffer.putFloat(this.z);
        this.buffer.putFloat(this.u);
        this.buffer.putFloat(this.v);
        this.buffer.putInt(this.hasFixedColor ? this.fixedColor : this.color);
        this.buffer.putInt(this.light);
        this.resetCurrentVertex();
        ++this.currentVertex;
    }

    public void reset() {
        this.buffer.rewind();
        this.currentVertex = 0;
        Arrays.fill(this.sideCount, 0);
        this.resetCurrentVertex();
    }

    public boolean flush(ChunkModelBuilder buffers, Material material, Vector3fc origin) {
        if (this.currentVertex == 0) {
            return false;
        }
        int numQuads = this.currentVertex >> 2;
        for (int quadIdx = 0; quadIdx < numQuads; ++quadIdx) {
            int normal = this.buffer.getInt(quadIdx << 2 << 5);
            class_2350 dir = normal != -1 ? DirectionUtil.ALL_DIRECTIONS[normal] : null;
            ModelQuadFacing facing = dir != null ? ModelQuadFacing.fromDirection((class_2350)dir) : ModelQuadFacing.UNASSIGNED;
            int n = facing.ordinal();
            this.sideCount[n] = this.sideCount[n] + 1;
        }
        int byteSize = this.currentVertex << 5;
        int sideMask = 0;
        this.buffer.rewind();
        while (this.buffer.position() < byteSize) {
            int normal = this.buffer.getInt();
            class_2350 dir = normal != -1 ? DirectionUtil.ALL_DIRECTIONS[normal] : null;
            ModelQuadFacing facing = dir != null ? ModelQuadFacing.fromDirection((class_2350)dir) : ModelQuadFacing.UNASSIGNED;
            int facingIdx = facing.ordinal();
            ChunkMeshBufferBuilder sink = buffers.getVertexBuffer(facing);
            ChunkVertexEncoder.Vertex[] sodiumQuad = this.sodiumVertexArray;
            for (int i = 0; i < 4; ++i) {
                if (i != 0) {
                    this.buffer.getInt();
                }
                ChunkVertexEncoder.Vertex sodiumVertex = sodiumQuad[i];
                sodiumVertex.x = origin.x() + this.buffer.getFloat();
                sodiumVertex.y = origin.y() + this.buffer.getFloat();
                sodiumVertex.z = origin.z() + this.buffer.getFloat();
                sodiumVertex.u = this.buffer.getFloat();
                sodiumVertex.v = this.buffer.getFloat();
                sodiumVertex.color = this.buffer.getInt();
                sodiumVertex.light = this.buffer.getInt();
            }
            sink.push(sodiumQuad, material);
            sideMask = (byte)(sideMask | 1 << facingIdx);
        }
        return true;
    }

    private void resetCurrentVertex() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.nz = 0.0f;
        this.ny = 0.0f;
        this.nx = 0.0f;
        this.v = 0.0f;
        this.u = 0.0f;
        this.color = -1;
        this.light = 0;
    }
}

