/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils.fabric;

import com.mojang.authlib.GameProfile;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidInfo;
import com.telepathicgrunt.the_bumblezone.items.BzCustomBucketItem;
import com.telepathicgrunt.the_bumblezone.mixin.fabric.entity.EntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.fabric.item.BucketItemAccessor;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.fabric.RestrictedPortalsCompat;
import com.telepathicgrunt.the_bumblezone.platform.ModInfo;
import com.telepathicgrunt.the_bumblezone.utils.fabric.FabricModInfo;
import java.util.List;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2402;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Contract;

public class PlatformHooksImpl {
    public static <T extends class_1308> class_1299<T> createEntityType(class_1299.class_4049<T> entityFactory, class_1311 category, float size, boolean scalable, int clientTrackingRange, int updateInterval, String buildName) {
        return FabricEntityTypeBuilder.createMob().spawnGroup(category).entityFactory(entityFactory).dimensions(scalable ? class_4048.method_18384((float)size, (float)size) : class_4048.method_18385((float)size, (float)size)).trackRangeChunks(clientTrackingRange).trackedUpdateRate(updateInterval).build();
    }

    public static <T extends class_1308> class_1299<T> createEntityType(class_1299.class_4049<T> entityFactory, class_1311 category, float xzSize, float ySize, boolean scalable, int clientTrackingRange, int updateInterval, String buildName) {
        return FabricEntityTypeBuilder.createMob().spawnGroup(category).entityFactory(entityFactory).dimensions(scalable ? class_4048.method_18384((float)xzSize, (float)ySize) : class_4048.method_18385((float)xzSize, (float)ySize)).trackRangeChunks(clientTrackingRange).trackedUpdateRate(updateInterval).build();
    }

    public static ModInfo getModInfo(String modid, boolean qualifierIsVersion) {
        return FabricLoader.getInstance().getModContainer(modid).map(container -> new FabricModInfo(container.getMetadata())).orElse(null);
    }

    @Contract(pure=true)
    public static class_3611 getBucketFluid(class_1755 bucket) {
        class_3611 fluid = ((BucketItemAccessor)bucket).bz$getContents();
        return fluid == null ? class_3612.field_15906 : fluid;
    }

    @Contract(pure=true)
    public static boolean hasCraftingRemainder(class_1799 stack) {
        return stack.method_7909().method_7857();
    }

    @Contract(pure=true)
    public static class_1799 getCraftingRemainder(class_1799 stack) {
        class_1792 item = stack.method_7909().method_7858();
        return item == null ? class_1799.field_8037 : new class_1799((class_1935)item);
    }

    @Contract(pure=true)
    public static int getXpDrop(class_1309 entity, class_1657 attackingPlayer, int xp) {
        return xp;
    }

    @Contract(pure=true)
    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    @Contract(pure=true)
    public static boolean isFakePlayer(class_3222 player) {
        return player != null && player.getClass() != class_3222.class;
    }

    @Contract(pure=true)
    public static class_3222 getFakePlayer(class_3218 level, GameProfile gameProfile) {
        if (gameProfile == null) {
            return FakePlayer.get((class_3218)level);
        }
        return FakePlayer.get((class_3218)level, (GameProfile)gameProfile);
    }

    @Contract(pure=true)
    public static class_1315 finalizeSpawn(class_1308 entity, class_5425 world, class_1315 spawnGroupData, class_3730 spawnReason, class_2487 tag) {
        return entity.method_5943(world, world.method_8404(entity.method_24515()), spawnReason, spawnGroupData, tag);
    }

    public static boolean sendBlockBreakEvent(class_1937 level, class_2338 pos, class_2680 state, class_2586 entity, class_1657 player) {
        boolean result = ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(level, player, pos, state, entity);
        if (!result) {
            ((PlayerBlockBreakEvents.Canceled)PlayerBlockBreakEvents.CANCELED.invoker()).onBlockBreakCanceled(level, player, pos, state, entity);
            return true;
        }
        return false;
    }

    public static void afterBlockBreakEvent(class_1937 level, class_2338 pos, class_2680 state, class_2586 entity, class_1657 player) {
        ((PlayerBlockBreakEvents.After)PlayerBlockBreakEvents.AFTER.invoker()).afterBlockBreak(level, player, pos, state, entity);
    }

    public static double getFluidHeight(class_1297 entity, class_6862<class_3611> fallback, FluidInfo ... fluids) {
        return entity.method_5861(fallback);
    }

    public static boolean isEyesInNoFluid(class_1297 entity) {
        return ((EntityAccessor)entity).getFluidOnEyes().isEmpty();
    }

    public static class_1271<class_1799> performItemUse(class_1937 world, class_1657 user, class_1268 hand, class_3611 fluid, BzCustomBucketItem bzCustomBucketItem) {
        class_1799 itemStack = user.method_5998(hand);
        class_3965 blockHitResult = class_1792.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)(fluid == class_3612.field_15906 ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348));
        if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
            return class_1271.method_22430((Object)itemStack);
        }
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)itemStack);
        }
        class_2338 blockPos = blockHitResult.method_17777();
        class_2350 direction = blockHitResult.method_17780();
        class_2338 blockPos2 = blockPos.method_10093(direction);
        if (world.method_8505(user, blockPos) && user.method_7343(blockPos2, direction, itemStack)) {
            class_2338 blockPos3;
            if (fluid == class_3612.field_15906) {
                class_2263 fluidDrainable;
                class_1799 itemStack2;
                class_2680 blockState = world.method_8320(blockPos);
                class_2248 class_22482 = blockState.method_26204();
                if (class_22482 instanceof class_2263 && !(itemStack2 = (fluidDrainable = (class_2263)class_22482).method_9700(user, (class_1936)world, blockPos, blockState)).method_7960()) {
                    user.method_7259(class_3468.field_15372.method_14956((Object)bzCustomBucketItem));
                    fluidDrainable.method_32351().ifPresent(sound -> user.method_5783(sound, 1.0f, 1.0f));
                    world.method_33596((class_1297)user, class_5712.field_28167, blockPos);
                    class_1799 itemStack3 = class_5328.method_30012((class_1799)itemStack, (class_1657)user, (class_1799)itemStack2);
                    if (user instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)user;
                        class_174.field_1208.method_8932(serverPlayer, itemStack2);
                    }
                    return class_1271.method_29237((Object)itemStack3, (boolean)world.method_8608());
                }
                return class_1271.method_22431((Object)itemStack);
            }
            class_2680 blockState = world.method_8320(blockPos);
            class_2338 class_23382 = blockPos3 = blockState.method_26204() instanceof class_2402 && fluid.method_15791(class_3486.field_15517) ? blockPos : blockPos2;
            if (bzCustomBucketItem.method_7731(user, world, blockPos3, blockHitResult)) {
                bzCustomBucketItem.method_7728(user, world, itemStack, blockPos3);
                if (user instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)user;
                    class_174.field_1191.method_23889(serverPlayer, blockPos3, itemStack);
                }
                user.method_7259(class_3468.field_15372.method_14956((Object)bzCustomBucketItem));
                return class_1271.method_29237((Object)class_1755.method_7732((class_1799)itemStack, (class_1657)user), (boolean)world.method_8608());
            }
            return class_1271.method_22431((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public static boolean isPermissionAllowedAtSpot(class_1937 level, class_1297 entity, class_2338 pos, boolean placingBlock) {
        if (placingBlock) {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return player.method_36971(level, pos) && ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(level, player, pos, level.method_8320(pos), null);
            }
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return player.method_36971(level, pos) && ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(level, player, pos, level.method_8320(pos), null);
        }
        return true;
    }

    public static boolean isDimensionAllowed(class_3222 serverPlayer, class_5321<class_1937> dimension) {
        if (ModChecker.restrictedPortalsPresent) {
            return !RestrictedPortalsCompat.isDimensionDisallowed(serverPlayer, dimension);
        }
        return true;
    }

    public static boolean isToolAction(class_1799 stack, Class<?> targetBackupClass, String ... targetToolAction) {
        return targetBackupClass.isInstance(stack.method_7909());
    }

    public static void disableFlight(class_1657 player) {
        player.method_31549().field_7479 = false;
        player.method_31549().field_7478 = false;
        if (player.method_37908().method_8608()) {
            return;
        }
        player.method_7355();
    }

    public static boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean shouldMobSplit(class_1308 parent, List<class_1308> children) {
        return true;
    }

    public static class_3611 getBucketItemFluid(class_1755 stack) {
        return ((BucketItemAccessor)stack).bz$getContents();
    }
}

